/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import jakarta.jms.Connection;
import jakarta.jms.ExceptionListener;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.broker.policy.AbortSlowConsumerBase;
import org.apache.activemq.util.MessageIdList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class AbortSlowConsumer1Test
extends AbortSlowConsumerBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbortSlowConsumer1Test.class);

    @Parameterized.Parameters(name="abortConnection({0})-isTopic({1})")
    public static Collection<Object[]> getTestParameters() {
        return Arrays.asList({Boolean.TRUE, Boolean.TRUE}, {Boolean.FALSE, Boolean.TRUE});
    }

    public AbortSlowConsumer1Test(Boolean abortConnection, Boolean topic) {
        this.abortConnection = abortConnection;
        this.topic = topic;
    }

    @Test(timeout=60000L)
    public void testSlowConsumerIsAborted() throws Exception {
        this.startConsumers(this.destination);
        Map.Entry consumertoAbort = this.consumers.entrySet().iterator().next();
        ((MessageIdList)((Object)consumertoAbort.getValue())).setProcessingDelay(8000L);
        for (Connection c : this.connections) {
            c.setExceptionListener((ExceptionListener)this);
        }
        this.startProducers(this.destination, 100);
        ((MessageIdList)((Object)consumertoAbort.getValue())).assertMessagesReceived(1);
        TimeUnit.SECONDS.sleep(5L);
        ((MessageIdList)((Object)consumertoAbort.getValue())).assertAtMostMessagesReceived(1);
    }

    @Test(timeout=60000L)
    public void testAbortAlreadyClosedConsumers() throws Exception {
        Connection conn = this.createConnectionFactory().createConnection();
        conn.setExceptionListener((ExceptionListener)this);
        this.connections.add(conn);
        Session sess = conn.createSession(false, 2);
        MessageConsumer consumer = sess.createConsumer(this.destination);
        conn.start();
        this.startProducers(this.destination, 20);
        TimeUnit.SECONDS.sleep(1L);
        LOG.info("closing consumer: " + consumer);
        consumer.close();
        TimeUnit.SECONDS.sleep(5L);
        Assert.assertTrue((String)("no exceptions : " + this.exceptions.toArray()), (boolean)this.exceptions.isEmpty());
    }

    @Test(timeout=60000L)
    public void testAbortAlreadyClosedConnection() throws Exception {
        Connection conn = this.createConnectionFactory().createConnection();
        conn.setExceptionListener((ExceptionListener)this);
        Session sess = conn.createSession(false, 2);
        sess.createConsumer(this.destination);
        conn.start();
        this.startProducers(this.destination, 20);
        TimeUnit.SECONDS.sleep(1L);
        LOG.info("closing connection: " + conn);
        conn.close();
        TimeUnit.SECONDS.sleep(5L);
        Assert.assertTrue((String)("no exceptions : " + this.exceptions.toArray()), (boolean)this.exceptions.isEmpty());
    }
}

