/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.io.File;
import java.util.ArrayList;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MaxDestinationsPolicyTest {
    BrokerService broker;
    ConnectionFactory factory;
    Connection connection;
    Session session;
    MessageProducer producer;

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        File testDataDir = new File("target/activemq-data/AMQ-5751");
        this.broker.setDataDirectoryFile(testDataDir);
        this.broker.setUseJmx(true);
        this.broker.setDeleteAllMessagesOnStartup(true);
        this.broker.getSystemUsage().getMemoryUsage().setLimit(0x4000000L);
        KahaDBPersistenceAdapter persistenceAdapter = new KahaDBPersistenceAdapter();
        persistenceAdapter.setDirectory(new File(testDataDir, "kahadb"));
        this.broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.factory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getConnectUri().toString());
        this.connection = this.factory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
    }

    @After
    public void tearDown() throws Exception {
        this.session.close();
        this.connection.stop();
        this.connection.close();
        this.broker.stop();
    }

    @Test
    public void testMaxDestinationDefaultPolicySuccess() throws Exception {
        this.applyDefaultMaximumDestinationPolicy(10);
        for (int i = 0; i < 10; ++i) {
            this.createQueue("queue." + i);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testMaxDestinationDefaultPolicyFail() throws Exception {
        this.applyDefaultMaximumDestinationPolicy(10);
        for (int i = 0; i < 11; ++i) {
            this.createQueue("queue." + i);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testMaxDestinationOnQueuePolicy() throws Exception {
        PolicyMap policyMap = this.applyDefaultMaximumDestinationPolicy(10);
        this.applyMaximumDestinationPolicy(policyMap, (ActiveMQDestination)new ActiveMQQueue("queue.>"), 5);
        for (int i = 0; i < 6; ++i) {
            this.createQueue("queue." + i);
        }
    }

    @Test
    public void testTopicMaxDestinationDefaultPolicySuccess() throws Exception {
        this.applyDefaultMaximumDestinationPolicy(10);
        for (int i = 0; i < 10; ++i) {
            this.createTopic("topic." + i);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testTopicMaxDestinationDefaultPolicyFail() throws Exception {
        this.applyDefaultMaximumDestinationPolicy(20);
        for (int i = 0; i < 21; ++i) {
            this.createTopic("topic." + i);
        }
    }

    @Test
    public void testTopicDefaultPolicyNoMaxDestinations() throws Exception {
        this.applyDefaultMaximumDestinationPolicy(-1);
        for (int i = 0; i < 100; ++i) {
            this.createTopic("topic." + i);
        }
    }

    @Test
    public void testComplexMaxDestinationPolicy() throws Exception {
        int i;
        PolicyMap policyMap = this.applyMaximumDestinationPolicy(new PolicyMap(), (ActiveMQDestination)new ActiveMQQueue("queue.>"), 5);
        this.applyMaximumDestinationPolicy(policyMap, (ActiveMQDestination)new ActiveMQTopic("topic.>"), 10);
        for (i = 0; i < 5; ++i) {
            this.createQueue("queue." + i);
        }
        for (i = 0; i < 10; ++i) {
            this.createTopic("topic." + i);
        }
        boolean fail = false;
        try {
            this.createTopic("topic.test");
        }
        catch (IllegalStateException e) {
            fail = true;
        }
        Assert.assertTrue((boolean)fail);
        fail = false;
        try {
            this.createQueue("queue.test");
        }
        catch (IllegalStateException e) {
            fail = true;
        }
        Assert.assertTrue((boolean)fail);
    }

    @Test
    public void testMaxDestinationPolicyOnChildDests() throws Exception {
        this.applyMaximumDestinationPolicy(new PolicyMap(), (ActiveMQDestination)new ActiveMQTopic("topic.>"), 10);
        for (int i = 0; i < 10; ++i) {
            this.createTopic("topic.test" + i);
        }
        boolean fail = false;
        try {
            this.createTopic("topic.abc.test");
        }
        catch (IllegalStateException e) {
            fail = true;
        }
        Assert.assertTrue((boolean)fail);
    }

    @Test(expected=IllegalStateException.class)
    public void testMaxDestinationOnTopicPolicy() throws Exception {
        PolicyMap policyMap = this.applyDefaultMaximumDestinationPolicy(10);
        this.applyMaximumDestinationPolicy(policyMap, (ActiveMQDestination)new ActiveMQTopic("topic.>"), 5);
        for (int i = 0; i < 6; ++i) {
            this.createTopic("topic." + i);
        }
    }

    private PolicyMap applyMaximumDestinationPolicy(PolicyMap policyMap, ActiveMQDestination destination, int maxDestinations) {
        PolicyEntry entry = new PolicyEntry();
        entry.setDestination(destination);
        entry.setMaxDestinations(maxDestinations);
        ArrayList<PolicyEntry> policyEntries = new ArrayList<PolicyEntry>();
        policyEntries.add(entry);
        policyMap.setPolicyEntries(policyEntries);
        this.broker.setDestinationPolicy(policyMap);
        return policyMap;
    }

    private PolicyMap applyDefaultMaximumDestinationPolicy(int maxDestinations) {
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        if (maxDestinations >= 0) {
            defaultEntry.setMaxDestinations(maxDestinations);
        }
        policyMap.setDefaultEntry(defaultEntry);
        this.broker.setDestinationPolicy(policyMap);
        return policyMap;
    }

    private void createQueue(String queueName) throws Exception {
        Queue queue = this.session.createQueue(queueName);
        this.producer = this.session.createProducer((Destination)queue);
    }

    private void createTopic(String topicName) throws Exception {
        Topic topic = this.session.createTopic(topicName);
        this.producer = this.session.createProducer((Destination)topic);
    }
}

