/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.broker.scheduler.JobListener;
import org.apache.activemq.broker.scheduler.JobScheduler;
import org.apache.activemq.store.kahadb.scheduler.JobSchedulerStoreImpl;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOHelper;
import org.apache.activemq.util.Wait;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerStoreCheckpointTest {
    static final Logger LOG = LoggerFactory.getLogger(JobSchedulerStoreCheckpointTest.class);
    private JobSchedulerStoreImpl store;
    private JobScheduler scheduler;
    private ByteSequence payload;

    @Before
    public void setUp() throws Exception {
        ((org.apache.logging.log4j.core.Logger)org.apache.logging.log4j.core.Logger.class.cast(LogManager.getLogger(JobSchedulerStoreImpl.class))).setLevel(Level.TRACE);
        File directory = new File("target/test/ScheduledJobsDB");
        IOHelper.mkdirs((File)directory);
        IOHelper.deleteChildren((File)directory);
        this.startStore(directory);
        byte[] data = new byte[8192];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 256);
        }
        this.payload = new ByteSequence(data);
    }

    protected void startStore(File directory) throws Exception {
        this.store = new JobSchedulerStoreImpl();
        this.store.setDirectory(directory);
        this.store.setCheckpointInterval(5000L);
        this.store.setCleanupInterval(10000L);
        this.store.setJournalMaxFileLength(10240);
        this.store.start();
        this.scheduler = this.store.getJobScheduler("test");
        this.scheduler.startDispatching();
    }

    private int getNumJournalFiles() throws IOException {
        return this.store.getJournal().getFileMap().size();
    }

    @After
    public void tearDown() throws Exception {
        this.scheduler.stopDispatching();
        this.store.stop();
    }

    @Test
    public void testStoreCleanupLinear() throws Exception {
        int COUNT = 10;
        final CountDownLatch latch = new CountDownLatch(10);
        this.scheduler.addListener(new JobListener(){

            public void scheduledJob(String id, ByteSequence job) {
                latch.countDown();
            }
        });
        long time = TimeUnit.SECONDS.toMillis(30L);
        for (int i = 0; i < 10; ++i) {
            this.scheduler.schedule("id" + i, this.payload, "", time, 0L, 0);
        }
        int size = this.scheduler.getAllJobs().size();
        Assert.assertEquals((long)size, (long)10L);
        LOG.info("Number of journal log files: {}", (Object)this.getNumJournalFiles());
        Assert.assertTrue((boolean)latch.await(70L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)latch.getCount());
        for (int i = 0; i < 10; ++i) {
            this.scheduler.schedule("id" + i, this.payload, "", time, 0L, 0);
        }
        LOG.info("Number of journal log files: {}", (Object)this.getNumJournalFiles());
        Assert.assertTrue((boolean)latch.await(70L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)latch.getCount());
        Assert.assertTrue((String)("Should be only one log left: " + this.getNumJournalFiles()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return JobSchedulerStoreCheckpointTest.this.getNumJournalFiles() == 1;
            }
        }, (long)TimeUnit.MINUTES.toMillis(2L)));
        LOG.info("Number of journal log files: {}", (Object)this.getNumJournalFiles());
    }

    @Test
    public void testColocatedAddRemoveCleanup() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.scheduler.addListener(new JobListener(){

            public void scheduledJob(String id, ByteSequence job) {
                latch.countDown();
            }
        });
        byte[] data = new byte[1024];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 256);
        }
        long time = TimeUnit.SECONDS.toMillis(2L);
        this.scheduler.schedule("Message-1", new ByteSequence(data), "", time, 0L, 0);
        Assert.assertTrue((boolean)latch.await(70L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)latch.getCount());
        this.scheduler.schedule("Message-2", this.payload, "", time, 0L, 0);
        this.scheduler.schedule("Message-3", this.payload, "", time, 0L, 0);
        Assert.assertTrue((String)("Should be only one log left: " + this.getNumJournalFiles()), (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return JobSchedulerStoreCheckpointTest.this.getNumJournalFiles() == 1;
            }
        }, (long)TimeUnit.MINUTES.toMillis(2L)));
        LOG.info("Number of journal log files: {}", (Object)this.getNumJournalFiles());
    }
}

