/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.ArrayList;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReduceMemoryFootprintTest {
    private static final Logger LOG = LoggerFactory.getLogger(ReduceMemoryFootprintTest.class);
    private static final String TEST_AMQ_BROKER_URI = "tcp://localhost:0";
    private static final String TEST_QUEUE_NAME = "Reduce.Memory.Footprint.Test";
    private static final String PROP_NAME = "prop_name";
    private static final String PROP_VALUE = "test-value";
    private String connectionURI;
    private BrokerService broker;

    @Before
    public void setUp() throws Exception {
        this.broker = this.createBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionURI = this.broker.getTransportConnectorByName("openwire").getPublishableConnectString();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test(timeout=60000L)
    public void testPropertyLostNonScheduled() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.connectionURI);
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)new ActiveMQQueue(TEST_QUEUE_NAME));
        connection.start();
        String messageText = this.createMessageText();
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setStringProperty(PROP_NAME, PROP_VALUE);
        message.setText(messageText);
        producer.send((Message)message);
        session.commit();
        LOG.info("Attempting to receive non-scheduled message");
        Message receivedMessage = this.consumeMessages(connection);
        Assert.assertNotNull((Object)receivedMessage);
        Assert.assertEquals((String)"property should match", (Object)PROP_VALUE, (Object)receivedMessage.getStringProperty(PROP_NAME));
        connection.close();
    }

    @Test(timeout=60000L)
    public void testPropertyLostScheduled() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.connectionURI);
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)new ActiveMQQueue(TEST_QUEUE_NAME));
        connection.start();
        String messageText = this.createMessageText();
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setStringProperty(PROP_NAME, PROP_VALUE);
        message.setLongProperty("AMQ_SCHEDULED_DELAY", 1000L);
        message.setText(messageText);
        producer.send((Message)message);
        session.commit();
        LOG.info("Attempting to receive scheduled message");
        Message receivedMessage = this.consumeMessages(connection);
        Assert.assertNotNull((Object)receivedMessage);
        Assert.assertEquals((String)"property should match", (Object)PROP_VALUE, (Object)receivedMessage.getStringProperty(PROP_NAME));
        connection.close();
    }

    private String createMessageText() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 50; ++i) {
            buffer.append("1234567890");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message consumeMessages(Connection connection) {
        Message message = null;
        try {
            Session session = connection.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer((Destination)new ActiveMQQueue(TEST_QUEUE_NAME));
            message = consumer.receive(45000L);
        }
        catch (Exception ex) {
            Assert.fail((String)("during consume message received exception " + ex.getMessage()));
        }
        return message;
    }

    private BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        PolicyMap policyMap = new PolicyMap();
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        PolicyEntry pe = new PolicyEntry();
        pe.setReduceMemoryFootprint(true);
        pe.setOptimizedDispatch(true);
        pe.setQueue(">");
        entries.add(pe);
        policyMap.setPolicyEntries(entries);
        broker.setDestinationPolicy(policyMap);
        broker.deleteAllMessages();
        broker.setSchedulerSupport(true);
        broker.addConnector(TEST_AMQ_BROKER_URI).setName("openwire");
        return broker;
    }
}

