/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.DestinationInfo;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ7088Test {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ7088Test.class);
    BrokerService brokerService;
    ConnectionFactory connectionFactory;

    @Before
    public void createBroker() throws Exception {
        this.createBroker(true);
    }

    public void createBroker(boolean delete) throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setDeleteAllMessagesOnStartup(delete);
        this.brokerService.setAdvisorySupport(false);
        this.brokerService.addConnector("tcp://localhost:0");
        this.brokerService.start();
        ActiveMQConnectionFactory activeMQConnectionFactory = new ActiveMQConnectionFactory(this.brokerService.getTransportConnectorByScheme("tcp").getPublishableConnectString());
        ActiveMQPrefetchPolicy zeroPrefetch = new ActiveMQPrefetchPolicy();
        zeroPrefetch.setAll(0);
        activeMQConnectionFactory.setPrefetchPolicy(zeroPrefetch);
        activeMQConnectionFactory.setWatchTopicAdvisories(false);
        this.connectionFactory = activeMQConnectionFactory;
    }

    @After
    public void stopBroker() throws Exception {
        this.brokerService.stop();
    }

    @Test
    public void testDeadlockOnAddRemoveDest() throws Exception {
        int numConnections = 100;
        final AtomicInteger numConsumers = new AtomicInteger(100);
        ExecutorService executorService = Executors.newFixedThreadPool(100);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    do {
                        int i;
                        if ((i = numConsumers.decrementAndGet()) < 0) continue;
                        Connection connection1 = AMQ7088Test.this.connectionFactory.createConnection();
                        connection1.start();
                        Session session = connection1.createSession(false, 1);
                        ActiveMQQueue queue = new ActiveMQQueue("Consumer." + i + ".VirtualTopic.TEST.*");
                        MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
                        messageConsumer.close();
                        ActiveMQConnection activeMQConnection = (ActiveMQConnection)connection1;
                        DestinationInfo remove = new DestinationInfo();
                        remove.setConnectionId(activeMQConnection.getConnectionInfo().getConnectionId());
                        remove.setDestination((ActiveMQDestination)queue);
                        remove.setOperationType((byte)1);
                        activeMQConnection.getTransport().request((Object)remove);
                        connection1.close();
                    } while (numConsumers.get() > 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        for (int i = 0; i < 100; ++i) {
            executorService.execute(runnable);
        }
        LOG.info("Letting it run to completion...");
        executorService.shutdown();
        Assert.assertTrue((String)"all done", (boolean)executorService.awaitTermination(5L, TimeUnit.MINUTES));
    }
}

