/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.virtual.MirroredQueue;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.usage.MemoryUsage;
import org.apache.activemq.usage.StoreUsage;
import org.apache.activemq.usage.SystemUsage;
import org.apache.activemq.usage.TempUsage;
import org.apache.activemq.util.IOHelper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class MirroredQueueCorrectMemoryUsageTest
extends EmbeddedBrokerTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MirroredQueueCorrectMemoryUsageTest.class);
    private static final long ONE_MB = 0x100000L;
    private static final long TEN_MB = 0xA00000L;
    private static final long TWENTY_MB = 0x1400000L;
    private static final String CREATED_STATIC_FOR_PERSISTENT = "created.static.for.persistent";

    @Override
    protected boolean isPersistent() {
        return true;
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        DestinationInterceptor[] destinationInterceptors = new DestinationInterceptor[1];
        MirroredQueue mq = new MirroredQueue();
        mq.setCopyMessage(true);
        mq.setPrefix("");
        mq.setPostfix(".qmirror");
        destinationInterceptors[0] = mq;
        broker.setDestinationInterceptors(destinationInterceptors);
        PolicyMap policyMap = new PolicyMap();
        LinkedList<PolicyEntry> entries = new LinkedList<PolicyEntry>();
        PolicyEntry policyEntry = new PolicyEntry();
        this.useTopic = true;
        ActiveMQDestination destination = super.createDestination(">");
        Assert.isTrue((boolean)destination.isTopic(), (String)"Created destination was not a topic");
        policyEntry.setDestination(destination);
        policyEntry.setProducerFlowControl(true);
        policyEntry.setMemoryLimit(0x100000L);
        entries.add(policyEntry);
        policyEntry = new PolicyEntry();
        this.useTopic = false;
        destination = super.createDestination(CREATED_STATIC_FOR_PERSISTENT);
        Assert.isTrue((boolean)destination.isQueue(), (String)"Created destination was not a queue");
        policyEntry.setDestination(destination);
        policyEntry.setProducerFlowControl(true);
        policyEntry.setMemoryLimit(0xA00000L);
        entries.add(policyEntry);
        policyMap.setPolicyEntries(entries);
        broker.setDestinationPolicy(policyMap);
        broker.setDestinations(new ActiveMQDestination[]{destination});
        SystemUsage memoryManager = new SystemUsage();
        MemoryUsage memoryUsage = new MemoryUsage();
        memoryUsage.setLimit(0xA00000L);
        memoryManager.setMemoryUsage(memoryUsage);
        StoreUsage storeUsage = new StoreUsage();
        storeUsage.setLimit(0x1400000L);
        memoryManager.setStoreUsage(storeUsage);
        TempUsage tempDiskUsage = new TempUsage();
        tempDiskUsage.setLimit(0xA00000L);
        memoryManager.setTempUsage(tempDiskUsage);
        broker.setSystemUsage(memoryManager);
        KahaDBPersistenceAdapter persistenceAdapter = new KahaDBPersistenceAdapter();
        persistenceAdapter.setJournalMaxFileLength(0xA00000);
        IOHelper.deleteFile((File)persistenceAdapter.getDirectory());
        broker.setPersistenceAdapter((PersistenceAdapter)persistenceAdapter);
        return broker;
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Test(timeout=40000L)
    public void testNoMemoryUsageIncreaseForTopic() throws Exception {
        Connection connection = super.createConnection();
        connection.start();
        Session session = connection.createSession(false, 2);
        Queue destination = session.createQueue(CREATED_STATIC_FOR_PERSISTENT);
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setDeliveryMode(2);
        char[] m = new char[1024];
        Arrays.fill(m, 'x');
        for (int i = 1; i < 12000; ++i) {
            producer.send((Message)session.createTextMessage(new String(m)));
            logger.debug("Sent message: " + i);
        }
        producer.close();
        session.close();
        connection.stop();
        connection.close();
    }
}

