/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.jmx.ManagementContext;

public class AMQ2513Test
extends TestCase {
    private BrokerService broker;
    private String connectionUri;

    void createBroker(boolean deleteAllMessagesOnStartup) throws Exception {
        this.broker = new BrokerService();
        this.broker.setBrokerName("localhost");
        this.broker.setUseJmx(true);
        this.broker.setDeleteAllMessagesOnStartup(deleteAllMessagesOnStartup);
        this.broker.addConnector("tcp://localhost:0");
        ManagementContext ctx = new ManagementContext();
        ctx.setCreateConnector(false);
        this.broker.setManagementContext(ctx);
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
    }

    public void testJmx() throws Exception {
        this.createBroker(true);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        Connection connection = factory.createConnection();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)session.createQueue("test"));
        producer.setDeliveryMode(2);
        connection.start();
        producer.send((Message)session.createTextMessage("test123"));
        DestinationViewMBean dv = this.createView();
        AMQ2513Test.assertTrue((dv.getQueueSize() > 0L ? 1 : 0) != 0);
        connection.close();
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.createBroker(false);
        factory = new ActiveMQConnectionFactory(this.connectionUri);
        connection = factory.createConnection();
        session = connection.createSession(false, 1);
        producer = session.createProducer((Destination)session.createQueue("test"));
        producer.setDeliveryMode(2);
        connection.start();
        producer.send((Message)session.createTextMessage("test123"));
        connection.close();
        dv = this.createView();
        AMQ2513Test.assertTrue((dv.getQueueSize() > 0L ? 1 : 0) != 0);
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    DestinationViewMBean createView() throws Exception {
        String domain = "org.apache.activemq";
        ObjectName name = new ObjectName(domain + ":type=Broker,brokerName=localhost,destinationType=Queue,destinationName=test");
        return (DestinationViewMBean)this.broker.getManagementContext().newProxyInstance(name, DestinationViewMBean.class, true);
    }
}

