/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.util.ClassLoadingAwareObjectInputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ3537Test
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Class[] TEST_CLASSES;
    private final List l = new ArrayList();

    @Before
    public void setUp() throws Exception {
        this.l.add("foo");
    }

    @Test
    public void testDeserializeProxy() throws Exception {
        List proxy = (List)Proxy.newProxyInstance(this.getClass().getClassLoader(), TEST_CLASSES, (InvocationHandler)this);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(proxy);
        byte[] serializedProxy = baos.toByteArray();
        oos.close();
        baos.close();
        ClassLoadingAwareObjectInputStream claois = new ClassLoadingAwareObjectInputStream((InputStream)new ByteArrayInputStream(serializedProxy));
        List deserializedProxy = (List)claois.readObject();
        claois.close();
        Assert.assertEquals((Object)"foo", deserializedProxy.get(0));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return method.invoke((Object)this.l, args);
    }

    static {
        System.setProperty("org.apache.activemq.SERIALIZABLE_PACKAGES", "com.sun.proxy,jdk.proxy2,java.util,org.apache.activemq.bugs");
        TEST_CLASSES = new Class[]{List.class, NonJDKList.class, Serializable.class};
    }

    public static interface NonJDKList {
        public int size();
    }
}

