/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.FilePendingSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.LastImageSubscriptionRecoveryPolicy;
import org.apache.activemq.broker.region.policy.PendingSubscriberMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.apache.activemq.transport.stomp.StompConnection;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ3622Test {
    protected static final Appender appender;
    protected static final AtomicBoolean failed;
    protected BrokerService broker;
    protected String connectionUri;
    protected Logger logger;

    @Before
    public void before() throws Exception {
        this.logger = (Logger)Logger.class.cast(LogManager.getRootLogger());
        this.logger.get().addAppender(appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        this.broker = new BrokerService();
        this.broker.setDataDirectory("target" + File.separator + "activemq-data");
        this.broker.setPersistent(true);
        this.broker.setDeleteAllMessagesOnStartup(true);
        PolicyEntry policy = new PolicyEntry();
        policy.setTopic(">");
        policy.setProducerFlowControl(false);
        policy.setMemoryLimit(0x100000L);
        policy.setPendingSubscriberPolicy((PendingSubscriberMessageStoragePolicy)new FilePendingSubscriberMessageStoragePolicy());
        policy.setSubscriptionRecoveryPolicy((SubscriptionRecoveryPolicy)new LastImageSubscriptionRecoveryPolicy());
        policy.setExpireMessagesPeriod(500L);
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        entries.add(policy);
        PolicyMap pMap = new PolicyMap();
        pMap.setPolicyEntries(entries);
        this.broker.setDestinationPolicy(pMap);
        this.connectionUri = this.broker.addConnector("stomp://localhost:0").getPublishableConnectString();
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void after() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.logger.removeAppender(appender);
    }

    @Test
    public void go() throws Exception {
        StompConnection connection = new StompConnection();
        Integer port = Integer.parseInt(this.connectionUri.split(":")[2]);
        connection.open("localhost", port.intValue());
        connection.connect("", "");
        connection.subscribe("/topic/foobar", "client");
        connection.disconnect();
        Thread.sleep(1000L);
        if (failed.get()) {
            Assert.fail((String)"Received NullPointerException");
        }
    }

    static {
        failed = new AtomicBoolean(false);
        appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                System.err.println(event.getMessage());
                if (event.getThrown() != null && event.getThrown() instanceof NullPointerException) {
                    failed.set(true);
                }
            }
        };
        appender.start();
    }
}

