/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.io.File;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4814Test {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ4814Test.class);
    private static final String CONNECTION_URL = "tcp://127.0.0.1:0";
    private static final String KAHADB_DIRECTORY = "./target/activemq-data/";
    private BrokerService broker;
    private String connectionURI;

    @Before
    public void setup() throws Exception {
        PolicyMap pm = new PolicyMap();
        PolicyEntry pe = new PolicyEntry();
        pe.setGcInactiveDestinations(true);
        pe.setInactiveTimeoutBeforeGC(1000L);
        pe.setProducerFlowControl(false);
        ActiveMQTopic d = new ActiveMQTopic(">");
        pe.setDestination((ActiveMQDestination)d);
        pm.put((ActiveMQDestination)d, (Object)pe);
        KahaDBStore kaha = new KahaDBStore();
        kaha.setDirectory(new File("./target/activemq-data/-LEAKTEST"));
        this.broker = new BrokerService();
        this.broker.setBrokerName("broker1");
        this.broker.setUseJmx(false);
        this.broker.setPersistenceAdapter((PersistenceAdapter)kaha);
        this.broker.setDestinationPolicy(pm);
        this.broker.setSchedulePeriodForDestinationPurge(1000);
        this.broker.setTimeBeforePurgeTempDestinations(1000);
        this.broker.setMaxPurgedDestinationsPerSweep(5000);
        this.broker.setOfflineDurableSubscriberTaskSchedule(1000L);
        this.broker.setOfflineDurableSubscriberTimeout(1000L);
        this.broker.setKeepDurableSubsActive(true);
        TransportConnector connector = this.broker.addConnector(CONNECTION_URL);
        this.broker.deleteAllMessages();
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionURI = connector.getPublishableConnectString();
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
            this.broker = null;
        }
    }

    @Test(timeout=60000L)
    public void testDurableTopicResourcesAreRemoved() throws Exception {
        LOG.info("Test starting.");
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionURI);
        for (int i = 0; i < 2; ++i) {
            LOG.info("Test main loop starting iteration: {}", (Object)(i + 1));
            Connection connection = factory.createConnection();
            connection.setClientID("client_id");
            connection.start();
            for (int j = 0; j < 8; ++j) {
                LOG.info("Test sub loop starting iteration: {}", (Object)(j + 1));
                Session session = connection.createSession(false, 1);
                String topicName = "durabletopic_" + j;
                String subscriberName = "subscriber_" + j;
                Topic topic = session.createTopic(topicName);
                TopicSubscriber subscriber = session.createDurableSubscriber(topic, subscriberName);
                subscriber.close();
                session.unsubscribe(subscriberName);
                session.close();
            }
            connection.stop();
            connection.close();
            connection = null;
            Thread.sleep(10L);
        }
        Assert.assertEquals((long)0L, (long)this.broker.getSystemUsage().getMemoryUsage().getNumUsageListeners());
        LOG.info("Test completed.");
    }
}

