/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.net.URI;
import java.util.ArrayList;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.security.AuthenticationUser;
import org.apache.activemq.security.AuthorizationEntry;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.AuthorizationPlugin;
import org.apache.activemq.security.DefaultAuthorizationMap;
import org.apache.activemq.security.SimpleAuthenticationPlugin;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ5814Test {
    private BrokerService brokerService;
    private String openwireClientUrl;

    public BrokerPlugin configureAuthentication() throws Exception {
        ArrayList<AuthenticationUser> users = new ArrayList<AuthenticationUser>();
        users.add(new AuthenticationUser("publisher", "123", "publisher"));
        users.add(new AuthenticationUser("subscriber", "123", "subscriber"));
        users.add(new AuthenticationUser("admin", "123", "publisher,subscriber"));
        SimpleAuthenticationPlugin authenticationPlugin = new SimpleAuthenticationPlugin(users);
        return authenticationPlugin;
    }

    public BrokerPlugin configureAuthorization() throws Exception {
        ArrayList<AuthorizationEntry> authorizationEntries = new ArrayList<AuthorizationEntry>();
        AuthorizationEntry entry = new AuthorizationEntry();
        entry.setTopic("dcu.>");
        entry.setRead("subscriber");
        entry.setWrite("publisher");
        entry.setAdmin("publisher,subscriber");
        authorizationEntries.add(entry);
        entry = new AuthorizationEntry();
        entry.setTopic("ActiveMQ.Advisory.>");
        entry.setRead("publisher,subscriber");
        entry.setWrite("publisher,subscriber");
        entry.setAdmin("publisher,subscriber");
        authorizationEntries.add(entry);
        DefaultAuthorizationMap authorizationMap = new DefaultAuthorizationMap(authorizationEntries);
        AuthorizationPlugin authorizationPlugin = new AuthorizationPlugin((AuthorizationMap)authorizationMap);
        return authorizationPlugin;
    }

    @Before
    public void setup() throws Exception {
        TransportConnector openwireConnector = new TransportConnector();
        openwireConnector.setUri(new URI("tcp://localhost:0"));
        openwireConnector.setName("openwire");
        ArrayList<BrokerPlugin> plugins = new ArrayList<BrokerPlugin>();
        plugins.add(this.configureAuthentication());
        plugins.add(this.configureAuthorization());
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.addConnector(openwireConnector);
        if (!plugins.isEmpty()) {
            BrokerPlugin[] array = new BrokerPlugin[plugins.size()];
            this.brokerService.setPlugins(plugins.toArray(array));
        }
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        this.openwireClientUrl = openwireConnector.getPublishableConnectString();
    }

    @After
    public void shutdown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
            this.brokerService = null;
        }
    }

    @Test(timeout=30000L)
    public void testProduceConsumeWithAuthorization() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.openwireClientUrl);
        Connection connection1 = factory.createConnection("subscriber", "123");
        Session session1 = connection1.createSession(false, 1);
        Topic wildCarded = session1.createTopic("dcu.>");
        MessageConsumer consumer = session1.createConsumer((Destination)wildCarded);
        connection1.start();
        Connection connection2 = factory.createConnection("publisher", "123");
        Session session2 = connection2.createSession(false, 1);
        Topic named = session2.createTopic("dcu.id");
        MessageProducer producer = session2.createProducer((Destination)named);
        producer.send((Message)session2.createTextMessage("test"));
        Assert.assertNotNull((Object)consumer.receive(2000L));
        connection1.close();
        connection2.close();
    }
}

