/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ6293Test {
    static final Logger LOG = LoggerFactory.getLogger(AMQ6293Test.class);
    private BrokerService brokerService;
    private String connectionUri;
    private final ExecutorService service = Executors.newFixedThreadPool(6);
    private final ActiveMQQueue queue = new ActiveMQQueue("test");
    private final int numMessages = 10000;
    private Connection connection;
    private Session session;
    private final AtomicBoolean isException = new AtomicBoolean();

    @Before
    public void before() throws Exception {
        this.brokerService = new BrokerService();
        TransportConnector connector = this.brokerService.addConnector("tcp://localhost:0");
        this.connectionUri = connector.getPublishableConnectString();
        this.brokerService.setPersistent(false);
        this.brokerService.getManagementContext().setCreateConnector(false);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry entry = new PolicyEntry();
        policyMap.setDefaultEntry(entry);
        this.brokerService.setDestinationPolicy(policyMap);
        entry.setQueuePrefetch(100);
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        this.connection = factory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
    }

    @After
    public void after() throws Exception {
        if (this.connection != null) {
            this.connection.stop();
        }
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
    }

    @Test(timeout=90000L)
    public void testDestinationStatisticsOnPurge() throws Exception {
        int i;
        this.sendTestMessages(10000);
        final Queue regionQueue = (Queue)this.brokerService.getRegionBroker().getDestinationMap().get(this.queue);
        for (i = 0; i < 5; ++i) {
            this.service.submit(new TestConsumer(this.session.createConsumer((Destination)this.queue)));
        }
        for (i = 0; i < 1; ++i) {
            this.service.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        regionQueue.purge();
                    }
                    catch (Exception e) {
                        AMQ6293Test.this.isException.set(true);
                        LOG.warn(e.getMessage(), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        this.service.shutdown();
        Assert.assertTrue((String)"Took too long to shutdown service", (boolean)this.service.awaitTermination(1L, TimeUnit.MINUTES));
        Assert.assertFalse((String)"Exception encountered", (boolean)this.isException.get());
        Assert.assertEquals((long)0L, (long)regionQueue.getDestinationStatistics().getMessages().getCount());
        Assert.assertEquals((long)10000L, (long)regionQueue.getDestinationStatistics().getDequeues().getCount());
    }

    private void sendTestMessages(int numMessages) throws JMSException {
        Session session = this.connection.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)this.queue);
        TextMessage textMessage = session.createTextMessage();
        textMessage.setText("Message");
        for (int i = 1; i <= numMessages; ++i) {
            producer.send((Message)textMessage);
            if (i % 1000 != 0) continue;
            LOG.info("Sent {} messages", (Object)i);
            session.commit();
        }
        session.close();
    }

    private class TestConsumer
    implements Runnable {
        private final MessageConsumer consumer;

        public TestConsumer(MessageConsumer consumer) throws JMSException {
            this.consumer = consumer;
        }

        @Override
        public void run() {
            try {
                int i = 0;
                while (this.consumer.receive(1000L) != null) {
                    if (++i % 1000 != 0) continue;
                    LOG.info("Received {} messages", (Object)i);
                }
            }
            catch (Exception e) {
                AMQ6293Test.this.isException.set(true);
                LOG.warn(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

