/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConsumerControl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AMQ9475Test {
    private BrokerService brokerService;
    private String connectionUri;
    private final ActiveMQDestination destination1;
    private final ActiveMQDestination destination2;

    @Parameterized.Parameters(name="queue={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    public AMQ9475Test(boolean queue) {
        this.destination1 = queue ? new ActiveMQQueue("a.>") : new ActiveMQTopic("a.>");
        this.destination2 = queue ? new ActiveMQQueue("a") : new ActiveMQTopic("a");
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory conFactory = new ActiveMQConnectionFactory(this.connectionUri);
        conFactory.setWatchTopicAdvisories(false);
        return conFactory;
    }

    @Before
    public void setUp() throws Exception {
        this.brokerService = BrokerFactory.createBroker((URI)new URI("broker://()/localhost?persistent=false&useJmx=true"));
        this.brokerService.addConnector("tcp://0.0.0.0:0");
        this.brokerService.start();
        this.connectionUri = this.brokerService.getTransportConnectorByScheme("tcp").getPublishableConnectString();
    }

    @Test
    public void testNormalWildcardSub() throws Exception {
        try (Connection connection = this.createConnectionFactory().createConnection();){
            connection.start();
            Session session = connection.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer((Destination)this.destination1);
            this.sendMessage(session, (Destination)this.destination2, "test");
            Assert.assertNotNull((Object)consumer.receive(1000L));
            Assert.assertNull(this.brokerService.getBroker().getDestinationMap().get(this.destination1));
            Assert.assertNotNull(this.brokerService.getBroker().getDestinationMap().get(this.destination2));
        }
    }

    @Test
    public void testWildcardConsumerControl() throws Exception {
        try (ActiveMQConnection connection = (ActiveMQConnection)this.createConnectionFactory().createConnection();){
            connection.start();
            Session session = connection.createSession(false, 1);
            ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)session.createConsumer((Destination)this.destination1);
            ConsumerControl control = new ConsumerControl();
            control.setDestination(this.destination1);
            control.setConsumerId(consumer.getConsumerId());
            control.setPrefetch(10);
            connection.syncSendPacket((Command)control);
            this.sendMessage(session, (Destination)this.destination2, "test");
            Assert.assertNotNull((Object)consumer.receive(1000L));
            Assert.assertNull(this.brokerService.getBroker().getDestinationMap().get(this.destination1));
            Assert.assertNotNull(this.brokerService.getBroker().getDestinationMap().get(this.destination2));
        }
    }

    @After
    public void tearDown() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    private void sendMessage(Session session, Destination destination, String text) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        producer.send((Message)session.createTextMessage(text));
        producer.close();
    }
}

