/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.Enumeration;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSQueueBrowserPriorityTest
extends TestCase {
    static final Logger LOG = LoggerFactory.getLogger(JMSQueueBrowserPriorityTest.class);
    private static final String TEST_AMQ_BROKER_URI = "tcp://localhost:0";
    private BrokerService broker;
    public static final byte[] PAYLOAD = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};

    protected void setUp() throws Exception {
        this.broker = this.createBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    protected void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public void testBrowsePriorityMessages() throws Exception {
        for (int i = 0; i < 5; ++i) {
            this.produceMessages(3, 4, "TestQ");
            Thread.sleep(1000L);
            this.produceMessages(3, 9, "TestQ");
            ArrayList<Integer> browseList = this.browseQueue("TestQ");
            this.produceMessages(3, 9, "TestQ");
            browseList = this.browseQueue("TestQ");
            ArrayList<Integer> consumeList = this.consumeMessages("TestQ");
            if (!browseList.equals(consumeList)) {
                LOG.info("browseList size " + browseList.size());
                LOG.info("consumeList size " + consumeList.size());
                LOG.info("browseList is:" + browseList);
                LOG.info("consumeList is:" + consumeList);
            }
            JMSQueueBrowserPriorityTest.assertTrue((String)("browseList and consumeList should be equal, iteration " + i), (boolean)browseList.equals(consumeList));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void produceMessages(int numberOfMessages, int priority, String queueName) throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.broker.getDefaultSocketURIString());
        try (Connection connection = connectionFactory.createConnection();){
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)new ActiveMQQueue(queueName));
            connection.start();
            for (int i = 0; i < numberOfMessages; ++i) {
                BytesMessage m = session.createBytesMessage();
                m.writeBytes(PAYLOAD);
                m.setJMSPriority(priority);
                producer.send((Message)m, 2, m.getJMSPriority(), 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Integer> browseQueue(String queueName) throws Exception {
        ArrayList<Integer> returnedMessages = new ArrayList<Integer>();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.broker.getDefaultSocketURIString());
        try (Connection connection = connectionFactory.createConnection();){
            Session session = connection.createSession(false, 1);
            QueueBrowser browser = session.createBrowser((Queue)new ActiveMQQueue(queueName));
            connection.start();
            Enumeration browsedMessages = browser.getEnumeration();
            while (browsedMessages.hasMoreElements()) {
                returnedMessages.add(((Message)browsedMessages.nextElement()).getJMSPriority());
            }
            ArrayList<Integer> arrayList = returnedMessages;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Integer> consumeMessages(String queueName) throws Exception {
        ArrayList<Integer> returnedMessages = new ArrayList<Integer>();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.broker.getDefaultSocketURIString());
        connectionFactory.setMessagePrioritySupported(true);
        try (Connection connection = connectionFactory.createConnection();){
            Session session = connection.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer((Destination)new ActiveMQQueue(queueName));
            connection.start();
            boolean finished = false;
            while (!finished) {
                Message message = consumer.receive(1000L);
                if (message == null) {
                    finished = true;
                }
                if (message == null) continue;
                returnedMessages.add(message.getJMSPriority());
            }
            ArrayList<Integer> arrayList = returnedMessages;
            return arrayList;
        }
    }

    private BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        PolicyMap policyMap = new PolicyMap();
        ArrayList<PolicyEntry> entries = new ArrayList<PolicyEntry>();
        PolicyEntry pe = new PolicyEntry();
        pe.setProducerFlowControl(true);
        pe.setUseCache(true);
        pe.setPrioritizedMessages(true);
        pe.setExpireMessagesPeriod(0L);
        pe.setQueue(">");
        entries.add(pe);
        policyMap.setPolicyEntries(entries);
        broker.setDestinationPolicy(policyMap);
        broker.addConnector(TEST_AMQ_BROKER_URI);
        broker.deleteAllMessages();
        return broker;
    }
}

