/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotWriteableException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTempTopic;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.Response;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.state.CommandVisitor;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQMessageTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveMQMessageTest.class);
    protected boolean readOnlyMessage;
    private String jmsMessageID;
    private String jmsCorrelationID;
    private ActiveMQDestination jmsDestination;
    private ActiveMQDestination jmsReplyTo;
    private int jmsDeliveryMode;
    private boolean jmsRedelivered;
    private String jmsType;
    private long jmsExpiration;
    private int jmsPriority;
    private long jmsTimestamp;
    private long[] consumerIDs;

    public ActiveMQMessageTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.jmsMessageID = "ID:TEST-ID:0:0:0:1";
        this.jmsCorrelationID = "testcorrelationid";
        this.jmsDestination = new ActiveMQTopic("test.topic");
        this.jmsReplyTo = new ActiveMQTempTopic("test.replyto.topic:001");
        this.jmsDeliveryMode = 2;
        this.jmsRedelivered = true;
        this.jmsType = "test type";
        this.jmsExpiration = 100000L;
        this.jmsPriority = 5;
        this.jmsTimestamp = System.currentTimeMillis();
        this.readOnlyMessage = false;
        this.consumerIDs = new long[3];
        for (int i = 0; i < this.consumerIDs.length; ++i) {
            this.consumerIDs[i] = i;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetDataStructureType() {
        ActiveMQMessage msg = new ActiveMQMessage();
        ActiveMQMessageTest.assertEquals((byte)msg.getDataStructureType(), (byte)23);
    }

    public void testHashCode() throws Exception {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSMessageID(this.jmsMessageID);
        ActiveMQMessageTest.assertTrue((msg.getJMSMessageID().hashCode() == this.jmsMessageID.hashCode() ? 1 : 0) != 0);
    }

    public void testSetReadOnly() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setReadOnlyProperties(true);
        boolean test = false;
        try {
            msg.setIntProperty("test", 1);
        }
        catch (MessageNotWriteableException me) {
            test = true;
        }
        catch (JMSException e) {
            e.printStackTrace(System.err);
            test = false;
        }
        ActiveMQMessageTest.assertTrue((boolean)test);
    }

    public void testSetToForeignJMSID() throws Exception {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSMessageID("ID:EMS-SERVER.8B443C380083:429");
    }

    public void testEqualsObject() throws Exception {
        ActiveMQMessage msg1 = new ActiveMQMessage();
        ActiveMQMessage msg2 = new ActiveMQMessage();
        msg1.setJMSMessageID(this.jmsMessageID);
        ActiveMQMessageTest.assertTrue((!msg1.equals((Object)msg2) ? 1 : 0) != 0);
        msg2.setJMSMessageID(this.jmsMessageID);
        ActiveMQMessageTest.assertTrue((boolean)msg1.equals((Object)msg2));
    }

    public void testShallowCopy() throws Exception {
        ActiveMQMessage msg1 = new ActiveMQMessage();
        msg1.setJMSMessageID(this.jmsMessageID);
        ActiveMQMessage msg2 = (ActiveMQMessage)msg1.copy();
        ActiveMQMessageTest.assertTrue((msg1 != msg2 && msg1.equals((Object)msg2) ? 1 : 0) != 0);
    }

    public void testCopy() throws Exception {
        this.jmsMessageID = "testid";
        this.jmsCorrelationID = "testcorrelationid";
        this.jmsDestination = new ActiveMQTopic("test.topic");
        this.jmsReplyTo = new ActiveMQTempTopic("test.replyto.topic:001");
        this.jmsDeliveryMode = 2;
        this.jmsRedelivered = true;
        this.jmsType = "test type";
        this.jmsExpiration = 100000L;
        this.jmsPriority = 5;
        this.jmsTimestamp = System.currentTimeMillis();
        this.readOnlyMessage = false;
        ActiveMQMessage msg1 = new ActiveMQMessage();
        msg1.setJMSMessageID(this.jmsMessageID);
        msg1.setJMSCorrelationID(this.jmsCorrelationID);
        msg1.setJMSDestination((Destination)this.jmsDestination);
        msg1.setJMSReplyTo((Destination)this.jmsReplyTo);
        msg1.setJMSDeliveryMode(this.jmsDeliveryMode);
        msg1.setJMSRedelivered(this.jmsRedelivered);
        msg1.setJMSType(this.jmsType);
        msg1.setJMSExpiration(this.jmsExpiration);
        msg1.setJMSPriority(this.jmsPriority);
        msg1.setJMSTimestamp(this.jmsTimestamp);
        msg1.setReadOnlyProperties(true);
        ActiveMQMessage msg2 = new ActiveMQMessage();
        msg1.copy(msg2);
        ActiveMQMessageTest.assertEquals((String)msg1.getJMSMessageID(), (String)msg2.getJMSMessageID());
        ActiveMQMessageTest.assertTrue((boolean)msg1.getJMSCorrelationID().equals(msg2.getJMSCorrelationID()));
        ActiveMQMessageTest.assertTrue((boolean)msg1.getJMSDestination().equals(msg2.getJMSDestination()));
        ActiveMQMessageTest.assertTrue((boolean)msg1.getJMSReplyTo().equals(msg2.getJMSReplyTo()));
        ActiveMQMessageTest.assertTrue((msg1.getJMSDeliveryMode() == msg2.getJMSDeliveryMode() ? 1 : 0) != 0);
        ActiveMQMessageTest.assertTrue((msg1.getJMSRedelivered() == msg2.getJMSRedelivered() ? 1 : 0) != 0);
        ActiveMQMessageTest.assertTrue((boolean)msg1.getJMSType().equals(msg2.getJMSType()));
        ActiveMQMessageTest.assertTrue((msg1.getJMSExpiration() == msg2.getJMSExpiration() ? 1 : 0) != 0);
        ActiveMQMessageTest.assertTrue((msg1.getJMSPriority() == msg2.getJMSPriority() ? 1 : 0) != 0);
        ActiveMQMessageTest.assertTrue((msg1.getJMSTimestamp() == msg2.getJMSTimestamp() ? 1 : 0) != 0);
        LOG.info("Message is:  " + msg1);
    }

    public void testGetAndSetJMSMessageID() throws Exception {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSMessageID(this.jmsMessageID);
        ActiveMQMessageTest.assertEquals((String)msg.getJMSMessageID(), (String)this.jmsMessageID);
    }

    public void testGetAndSetJMSTimestamp() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSTimestamp(this.jmsTimestamp);
        ActiveMQMessageTest.assertTrue((msg.getJMSTimestamp() == this.jmsTimestamp ? 1 : 0) != 0);
    }

    public void testGetJMSCorrelationIDAsBytes() throws Exception {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSCorrelationID(this.jmsCorrelationID);
        byte[] testbytes = msg.getJMSCorrelationIDAsBytes();
        String str2 = new String(testbytes);
        ActiveMQMessageTest.assertTrue((boolean)this.jmsCorrelationID.equals(str2));
    }

    public void testSetJMSCorrelationIDAsBytes() throws Exception {
        ActiveMQMessage msg = new ActiveMQMessage();
        byte[] testbytes = this.jmsCorrelationID.getBytes();
        msg.setJMSCorrelationIDAsBytes(testbytes);
        testbytes = msg.getJMSCorrelationIDAsBytes();
        String str2 = new String(testbytes);
        ActiveMQMessageTest.assertTrue((boolean)this.jmsCorrelationID.equals(str2));
    }

    public void testGetAndSetJMSCorrelationID() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSCorrelationID(this.jmsCorrelationID);
        ActiveMQMessageTest.assertTrue((boolean)msg.getJMSCorrelationID().equals(this.jmsCorrelationID));
    }

    public void testGetAndSetJMSReplyTo() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSReplyTo((Destination)this.jmsReplyTo);
        ActiveMQMessageTest.assertTrue((boolean)msg.getJMSReplyTo().equals(this.jmsReplyTo));
    }

    public void testGetAndSetJMSDestination() throws Exception {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSDestination((Destination)this.jmsDestination);
        ActiveMQMessageTest.assertTrue((boolean)msg.getJMSDestination().equals(this.jmsDestination));
    }

    public void testGetAndSetJMSDeliveryMode() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSDeliveryMode(this.jmsDeliveryMode);
        ActiveMQMessageTest.assertTrue((msg.getJMSDeliveryMode() == this.jmsDeliveryMode ? 1 : 0) != 0);
    }

    public void testGetAndSetMSRedelivered() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSRedelivered(this.jmsRedelivered);
        ActiveMQMessageTest.assertTrue((msg.getJMSRedelivered() == this.jmsRedelivered ? 1 : 0) != 0);
    }

    public void testGetAndSetJMSType() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSType(this.jmsType);
        ActiveMQMessageTest.assertTrue((boolean)msg.getJMSType().equals(this.jmsType));
    }

    public void testGetAndSetJMSExpiration() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSExpiration(this.jmsExpiration);
        ActiveMQMessageTest.assertTrue((msg.getJMSExpiration() == this.jmsExpiration ? 1 : 0) != 0);
    }

    public void testGetAndSetJMSPriority() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSPriority(this.jmsPriority);
        ActiveMQMessageTest.assertTrue((msg.getJMSPriority() == this.jmsPriority ? 1 : 0) != 0);
        msg.setJMSPriority(-90);
        ActiveMQMessageTest.assertEquals((int)0, (int)msg.getJMSPriority());
        msg.setJMSPriority(90);
        ActiveMQMessageTest.assertEquals((int)9, (int)msg.getJMSPriority());
    }

    public void testClearProperties() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setStringProperty("test", "test");
        msg.setContent(new ByteSequence(new byte[1], 0, 0));
        msg.setJMSMessageID(this.jmsMessageID);
        msg.clearProperties();
        ActiveMQMessageTest.assertNull((Object)msg.getStringProperty("test"));
        ActiveMQMessageTest.assertNotNull((Object)msg.getJMSMessageID());
        ActiveMQMessageTest.assertNotNull((Object)msg.getContent());
    }

    public void testPropertyExists() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setStringProperty("test", "test");
        ActiveMQMessageTest.assertTrue((boolean)msg.propertyExists("test"));
        msg.setIntProperty("JMSXDeliveryCount", 1);
        ActiveMQMessageTest.assertTrue((boolean)msg.propertyExists("JMSXDeliveryCount"));
    }

    public void testGetBooleanProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "booleanProperty";
        msg.setBooleanProperty(name, true);
        ActiveMQMessageTest.assertTrue((boolean)msg.getBooleanProperty(name));
    }

    public void testGetByteProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "byteProperty";
        msg.setByteProperty(name, (byte)1);
        ActiveMQMessageTest.assertTrue((msg.getByteProperty(name) == 1 ? 1 : 0) != 0);
    }

    public void testGetShortProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "shortProperty";
        msg.setShortProperty(name, (short)1);
        ActiveMQMessageTest.assertTrue((msg.getShortProperty(name) == 1 ? 1 : 0) != 0);
    }

    public void testGetIntProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "intProperty";
        msg.setIntProperty(name, 1);
        ActiveMQMessageTest.assertTrue((msg.getIntProperty(name) == 1 ? 1 : 0) != 0);
    }

    public void testGetLongProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "longProperty";
        msg.setLongProperty(name, 1L);
        ActiveMQMessageTest.assertTrue((msg.getLongProperty(name) == 1L ? 1 : 0) != 0);
    }

    public void testGetFloatProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "floatProperty";
        msg.setFloatProperty(name, 1.3f);
        ActiveMQMessageTest.assertTrue((msg.getFloatProperty(name) == 1.3f ? 1 : 0) != 0);
    }

    public void testGetDoubleProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "doubleProperty";
        msg.setDoubleProperty(name, 1.3);
        ActiveMQMessageTest.assertTrue((msg.getDoubleProperty(name) == 1.3 ? 1 : 0) != 0);
    }

    public void testGetStringProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "stringProperty";
        msg.setStringProperty(name, name);
        ActiveMQMessageTest.assertTrue((boolean)msg.getStringProperty(name).equals(name));
    }

    public void testGetObjectProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "floatProperty";
        msg.setFloatProperty(name, 1.3f);
        ActiveMQMessageTest.assertTrue((boolean)(msg.getObjectProperty(name) instanceof Float));
        ActiveMQMessageTest.assertTrue((((Float)msg.getObjectProperty(name)).floatValue() == 1.3f ? 1 : 0) != 0);
    }

    public void testSetJMSDeliveryModeProperty() throws JMSException {
        ActiveMQMessage message = new ActiveMQMessage();
        String propertyName = "JMSDeliveryMode";
        message.setObjectProperty(propertyName, (Object)Boolean.TRUE);
        ActiveMQMessageTest.assertTrue((boolean)message.isPersistent());
        message.setObjectProperty(propertyName, (Object)Boolean.FALSE);
        ActiveMQMessageTest.assertFalse((boolean)message.isPersistent());
        message.setBooleanProperty(propertyName, true);
        ActiveMQMessageTest.assertTrue((boolean)message.isPersistent());
        message.setBooleanProperty(propertyName, false);
        ActiveMQMessageTest.assertFalse((boolean)message.isPersistent());
        message.setObjectProperty(propertyName, (Object)2);
        ActiveMQMessageTest.assertTrue((boolean)message.isPersistent());
        message.setObjectProperty(propertyName, (Object)1);
        ActiveMQMessageTest.assertFalse((boolean)message.isPersistent());
        message.setIntProperty(propertyName, 2);
        ActiveMQMessageTest.assertTrue((boolean)message.isPersistent());
        message.setIntProperty(propertyName, 1);
        ActiveMQMessageTest.assertFalse((boolean)message.isPersistent());
        message.setObjectProperty(propertyName, (Object)"PERSISTENT");
        ActiveMQMessageTest.assertTrue((boolean)message.isPersistent());
        message.setObjectProperty(propertyName, (Object)"NON_PERSISTENT");
        ActiveMQMessageTest.assertFalse((boolean)message.isPersistent());
        message.setStringProperty(propertyName, "PERSISTENT");
        ActiveMQMessageTest.assertTrue((boolean)message.isPersistent());
        message.setStringProperty(propertyName, "NON_PERSISTENT");
        ActiveMQMessageTest.assertFalse((boolean)message.isPersistent());
    }

    public void testGetPropertyNames() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name1 = "floatProperty";
        msg.setFloatProperty(name1, 1.3f);
        String name2 = "JMSXDeliveryCount";
        msg.setIntProperty(name2, 1);
        String name3 = "JMSRedelivered";
        msg.setBooleanProperty(name3, false);
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        Enumeration iter = msg.getPropertyNames();
        while (iter.hasMoreElements()) {
            Object element = iter.nextElement();
            found1 |= element.equals(name1);
            found2 |= element.equals(name2);
            found3 |= element.equals(name3);
        }
        ActiveMQMessageTest.assertTrue((String)"prop name1 found", (boolean)found1);
        ActiveMQMessageTest.assertFalse((String)"prop name2 not found", (boolean)found2);
        ActiveMQMessageTest.assertFalse((String)"prop name4 not found", (boolean)found3);
    }

    public void testGetAllPropertyNames() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name1 = "floatProperty";
        msg.setFloatProperty(name1, 1.3f);
        String name2 = "JMSXDeliveryCount";
        msg.setIntProperty(name2, 1);
        String name3 = "JMSRedelivered";
        msg.setBooleanProperty(name3, false);
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        Enumeration iter = msg.getAllPropertyNames();
        while (iter.hasMoreElements()) {
            Object element = iter.nextElement();
            found1 |= element.equals(name1);
            found2 |= element.equals(name2);
            found3 |= element.equals(name3);
        }
        ActiveMQMessageTest.assertTrue((String)"prop name1 found", (boolean)found1);
        ActiveMQMessageTest.assertTrue((String)"prop name2 found", (boolean)found2);
        ActiveMQMessageTest.assertTrue((String)"prop name4 found", (boolean)found3);
    }

    public void testSetObjectProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "property";
        try {
            msg.setObjectProperty(name, (Object)"string");
            msg.setObjectProperty(name, (Object)Byte.valueOf("1"));
            msg.setObjectProperty(name, (Object)Short.valueOf("1"));
            msg.setObjectProperty(name, (Object)Integer.valueOf("1"));
            msg.setObjectProperty(name, (Object)Long.valueOf("1"));
            msg.setObjectProperty(name, (Object)Float.valueOf("1.1f"));
            msg.setObjectProperty(name, (Object)Double.valueOf("1.1"));
            msg.setObjectProperty(name, (Object)Boolean.TRUE);
            msg.setObjectProperty(name, null);
        }
        catch (MessageFormatException e) {
            ActiveMQMessageTest.fail((String)"should accept object primitives and String");
        }
        try {
            msg.setObjectProperty(name, (Object)new byte[5]);
            ActiveMQMessageTest.fail((String)"should accept only object primitives and String");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.setObjectProperty(name, new Object());
            ActiveMQMessageTest.fail((String)"should accept only object primitives and String");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    public void testConvertProperties() throws Exception {
        Message msg = new Message(){

            public Message copy() {
                return null;
            }

            public void beforeMarshall(WireFormat wireFormat) throws IOException {
                super.beforeMarshall(wireFormat);
            }

            public byte getDataStructureType() {
                return 0;
            }

            public Response visit(CommandVisitor visitor) throws Exception {
                return null;
            }

            public void clearBody() throws JMSException {
            }

            public void storeContent() {
            }

            public void storeContentAndClear() {
            }
        };
        msg.setProperty("stringProperty", (Object)"string");
        msg.setProperty("byteProperty", (Object)Byte.valueOf("1"));
        msg.setProperty("shortProperty", (Object)Short.valueOf("1"));
        msg.setProperty("intProperty", (Object)Integer.valueOf("1"));
        msg.setProperty("longProperty", (Object)Long.valueOf("1"));
        msg.setProperty("floatProperty", (Object)Float.valueOf("1.1f"));
        msg.setProperty("doubleProperty", (Object)Double.valueOf("1.1"));
        msg.setProperty("booleanProperty", (Object)Boolean.TRUE);
        msg.setProperty("nullProperty", null);
        msg.beforeMarshall((WireFormat)new OpenWireFormat());
        Map properties = msg.getProperties();
        ActiveMQMessageTest.assertEquals(properties.get("stringProperty"), (Object)"string");
        ActiveMQMessageTest.assertEquals((int)((Byte)properties.get("byteProperty")).byteValue(), (int)1);
        ActiveMQMessageTest.assertEquals((int)((Short)properties.get("shortProperty")).shortValue(), (int)1);
        ActiveMQMessageTest.assertEquals((int)((Integer)properties.get("intProperty")), (int)1);
        ActiveMQMessageTest.assertEquals((long)((Long)properties.get("longProperty")), (long)1L);
        ActiveMQMessageTest.assertEquals((float)((Float)properties.get("floatProperty")).floatValue(), (float)1.1f, (float)0.0f);
        ActiveMQMessageTest.assertEquals((double)((Double)properties.get("doubleProperty")), (double)1.1, (double)0.0);
        ActiveMQMessageTest.assertEquals((boolean)((Boolean)properties.get("booleanProperty")), (boolean)true);
        ActiveMQMessageTest.assertNull(properties.get("nullProperty"));
    }

    public void testSetNullProperty() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String name = "cheese";
        msg.setStringProperty(name, "Cheddar");
        ActiveMQMessageTest.assertEquals((String)"Cheddar", (String)msg.getStringProperty(name));
        msg.setStringProperty(name, null);
        ActiveMQMessageTest.assertEquals(null, (String)msg.getStringProperty(name));
    }

    public void testSetNullPropertyName() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        try {
            msg.setStringProperty(null, "Cheese");
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            LOG.info("Worked, caught: " + e);
        }
    }

    public void testSetEmptyPropertyName() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        try {
            msg.setStringProperty("", "Cheese");
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException e) {
            LOG.info("Worked, caught: " + e);
        }
    }

    public void testGetAndSetJMSXDeliveryCount() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setIntProperty("JMSXDeliveryCount", 1);
        int count = msg.getIntProperty("JMSXDeliveryCount");
        ActiveMQMessageTest.assertTrue((String)("expected delivery count = 1 - got: " + count), (count == 1 ? 1 : 0) != 0);
    }

    public void testClearBody() throws JMSException {
        ActiveMQBytesMessage message = new ActiveMQBytesMessage();
        message.clearBody();
        ActiveMQMessageTest.assertFalse((boolean)message.isReadOnlyBody());
        ActiveMQMessageTest.assertNull((Object)message.getContent());
    }

    public void testBooleanPropertyConversion() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String propertyName = "property";
        msg.setBooleanProperty(propertyName, true);
        ActiveMQMessageTest.assertEquals((boolean)((Boolean)msg.getObjectProperty(propertyName)), (boolean)true);
        ActiveMQMessageTest.assertTrue((boolean)msg.getBooleanProperty(propertyName));
        ActiveMQMessageTest.assertEquals((String)msg.getStringProperty(propertyName), (String)"true");
        try {
            msg.getByteProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getShortProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getIntProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getLongProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getFloatProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getDoubleProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    public void testBytePropertyConversion() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String propertyName = "property";
        msg.setByteProperty(propertyName, (byte)1);
        ActiveMQMessageTest.assertEquals((int)((Byte)msg.getObjectProperty(propertyName)).byteValue(), (int)1);
        ActiveMQMessageTest.assertEquals((int)msg.getByteProperty(propertyName), (int)1);
        ActiveMQMessageTest.assertEquals((int)msg.getShortProperty(propertyName), (int)1);
        ActiveMQMessageTest.assertEquals((int)msg.getIntProperty(propertyName), (int)1);
        ActiveMQMessageTest.assertEquals((long)msg.getLongProperty(propertyName), (long)1L);
        ActiveMQMessageTest.assertEquals((String)msg.getStringProperty(propertyName), (String)"1");
        try {
            msg.getBooleanProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getFloatProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getDoubleProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    public void testShortPropertyConversion() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String propertyName = "property";
        msg.setShortProperty(propertyName, (short)1);
        ActiveMQMessageTest.assertEquals((int)((Short)msg.getObjectProperty(propertyName)).shortValue(), (int)1);
        ActiveMQMessageTest.assertEquals((int)msg.getShortProperty(propertyName), (int)1);
        ActiveMQMessageTest.assertEquals((int)msg.getIntProperty(propertyName), (int)1);
        ActiveMQMessageTest.assertEquals((long)msg.getLongProperty(propertyName), (long)1L);
        ActiveMQMessageTest.assertEquals((String)msg.getStringProperty(propertyName), (String)"1");
        try {
            msg.getBooleanProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getByteProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getFloatProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getDoubleProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    public void testIntPropertyConversion() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String propertyName = "property";
        msg.setIntProperty(propertyName, 1);
        ActiveMQMessageTest.assertEquals((int)((Integer)msg.getObjectProperty(propertyName)), (int)1);
        ActiveMQMessageTest.assertEquals((int)msg.getIntProperty(propertyName), (int)1);
        ActiveMQMessageTest.assertEquals((long)msg.getLongProperty(propertyName), (long)1L);
        ActiveMQMessageTest.assertEquals((String)msg.getStringProperty(propertyName), (String)"1");
        try {
            msg.getBooleanProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getByteProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getShortProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getFloatProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getDoubleProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    public void testLongPropertyConversion() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String propertyName = "property";
        msg.setLongProperty(propertyName, 1L);
        ActiveMQMessageTest.assertEquals((long)((Long)msg.getObjectProperty(propertyName)), (long)1L);
        ActiveMQMessageTest.assertEquals((long)msg.getLongProperty(propertyName), (long)1L);
        ActiveMQMessageTest.assertEquals((String)msg.getStringProperty(propertyName), (String)"1");
        try {
            msg.getBooleanProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getByteProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getShortProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getIntProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getFloatProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getDoubleProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    public void testFloatPropertyConversion() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String propertyName = "property";
        msg.setFloatProperty(propertyName, 1.5f);
        ActiveMQMessageTest.assertEquals((double)((Float)msg.getObjectProperty(propertyName)).floatValue(), (double)1.5, (double)0.0);
        ActiveMQMessageTest.assertEquals((double)msg.getFloatProperty(propertyName), (double)1.5, (double)0.0);
        ActiveMQMessageTest.assertEquals((double)msg.getDoubleProperty(propertyName), (double)1.5, (double)0.0);
        ActiveMQMessageTest.assertEquals((String)msg.getStringProperty(propertyName), (String)"1.5");
        try {
            msg.getBooleanProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getByteProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getShortProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getIntProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getLongProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    public void testDoublePropertyConversion() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String propertyName = "property";
        msg.setDoubleProperty(propertyName, 1.5);
        ActiveMQMessageTest.assertEquals((double)((Double)msg.getObjectProperty(propertyName)), (double)1.5, (double)0.0);
        ActiveMQMessageTest.assertEquals((double)msg.getDoubleProperty(propertyName), (double)1.5, (double)0.0);
        ActiveMQMessageTest.assertEquals((String)msg.getStringProperty(propertyName), (String)"1.5");
        try {
            msg.getBooleanProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getByteProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getShortProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getIntProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getLongProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getFloatProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    public void testStringPropertyConversion() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String propertyName = "property";
        String stringValue = "true";
        msg.setStringProperty(propertyName, stringValue);
        ActiveMQMessageTest.assertEquals((String)msg.getStringProperty(propertyName), (String)stringValue);
        ActiveMQMessageTest.assertEquals((String)((String)msg.getObjectProperty(propertyName)), (String)stringValue);
        ActiveMQMessageTest.assertEquals((boolean)msg.getBooleanProperty(propertyName), (boolean)true);
        stringValue = "1";
        msg.setStringProperty(propertyName, stringValue);
        ActiveMQMessageTest.assertEquals((int)msg.getByteProperty(propertyName), (int)1);
        ActiveMQMessageTest.assertEquals((int)msg.getShortProperty(propertyName), (int)1);
        ActiveMQMessageTest.assertEquals((int)msg.getIntProperty(propertyName), (int)1);
        ActiveMQMessageTest.assertEquals((long)msg.getLongProperty(propertyName), (long)1L);
        stringValue = "1.5";
        msg.setStringProperty(propertyName, stringValue);
        ActiveMQMessageTest.assertEquals((double)msg.getFloatProperty(propertyName), (double)1.5, (double)0.0);
        ActiveMQMessageTest.assertEquals((double)msg.getDoubleProperty(propertyName), (double)1.5, (double)0.0);
        stringValue = "bad";
        msg.setStringProperty(propertyName, stringValue);
        try {
            msg.getByteProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            msg.getShortProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            msg.getIntProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            msg.getLongProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            msg.getFloatProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            msg.getDoubleProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ActiveMQMessageTest.assertFalse((boolean)msg.getBooleanProperty(propertyName));
    }

    public void testObjectPropertyConversion() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String propertyName = "property";
        Object obj = new Object();
        try {
            msg.setProperty(propertyName, obj);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            msg.getStringProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getBooleanProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getByteProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getShortProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getIntProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getLongProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getFloatProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
        try {
            msg.getDoubleProperty(propertyName);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageFormatException messageFormatException) {
            // empty catch block
        }
    }

    public void testReadOnlyProperties() throws JMSException {
        ActiveMQMessage msg = new ActiveMQMessage();
        String propertyName = "property";
        msg.setReadOnlyProperties(true);
        try {
            msg.setObjectProperty(propertyName, new Object());
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            msg.setStringProperty(propertyName, "test");
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            msg.setBooleanProperty(propertyName, true);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            msg.setByteProperty(propertyName, (byte)1);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            msg.setShortProperty(propertyName, (short)1);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            msg.setIntProperty(propertyName, 1);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            msg.setLongProperty(propertyName, 1L);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            msg.setFloatProperty(propertyName, 1.5f);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
        try {
            msg.setDoubleProperty(propertyName, 1.5);
            ActiveMQMessageTest.fail((String)"Should have thrown exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
    }

    public void testIsExpired() {
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setJMSExpiration(System.currentTimeMillis() - 1L);
        ActiveMQMessageTest.assertTrue((boolean)msg.isExpired());
        msg.setJMSExpiration(System.currentTimeMillis() + 10000L);
        ActiveMQMessageTest.assertFalse((boolean)msg.isExpired());
    }
}

