/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms2;

import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.Message;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.jms2.ActiveMQJMS2TestBase;
import org.apache.activemq.jms2.ActiveMQJMS2TestSupport;
import org.apache.activemq.jms2.MessageData;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ActiveMQJMS2AckModesTest
extends ActiveMQJMS2TestBase {
    private final String destinationName;
    private final String destinationType;
    private final int ackMode;
    private final String messagePayload;

    public ActiveMQJMS2AckModesTest(String destinationType, int ackMode) {
        this.destinationName = "AMQ.JMS2.ACKMODE." + Integer.toString(ackMode) + destinationType.toUpperCase();
        this.destinationType = destinationType;
        this.ackMode = ackMode;
        this.messagePayload = "Test message destType: " + destinationType + " ackMode: " + Integer.toString(ackMode);
    }

    @Parameterized.Parameters(name="destinationType={0}, ackMode={1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"queue", 4}, {"queue", 1}, {"queue", 2}, {"queue", 3}, {"queue", 0}, {"topic", 4}, {"topic", 1}, {"topic", 2}, {"topic", 3}, {"topic", 0}, {"temp-queue", 4}, {"temp-queue", 1}, {"temp-queue", 2}, {"temp-queue", 3}, {"temp-queue", 0}, {"temp-topic", 4}, {"temp-topic", 1}, {"temp-topic", 2}, {"temp-topic", 3}, {"temp-topic", 0});
    }

    @Test
    public void testAcknowledgementMode() {
        try (JMSContext jmsContext = activemqConnectionFactory.createContext("admin", "admin", this.ackMode);){
            Assert.assertNotNull((Object)jmsContext);
            Destination destination = ActiveMQJMS2TestSupport.generateDestination(jmsContext, this.destinationType, this.destinationName);
            Assert.assertNotNull((Object)destination);
            JMSConsumer jmsConsumer = jmsContext.createConsumer(destination);
            Assert.assertNotNull((Object)jmsConsumer);
            jmsContext.start();
            Message message = ActiveMQJMS2TestSupport.generateMessage(jmsContext, "text", this.messagePayload);
            LinkedList<String> sentMessageIds = new LinkedList<String>();
            for (int deliveryMode : Arrays.asList(1, 2)) {
                MessageData sendMessageData = new MessageData();
                sendMessageData.setMessage(message).setDeliveryMode(deliveryMode);
                sentMessageIds.add(ActiveMQJMS2TestSupport.sendMessage(jmsContext, destination, sendMessageData));
            }
            switch (this.ackMode) {
                case 0: {
                    jmsContext.commit();
                    break;
                }
            }
            Message recvMessage = null;
            Message lastRecvMessage = null;
            LinkedList<Message> recvMessages = new LinkedList<Message>();
            recvMessage = jmsConsumer.receive(2000L);
            while (recvMessage != null) {
                recvMessages.add(recvMessage);
                lastRecvMessage = recvMessage;
                switch (this.ackMode) {
                    case 4: {
                        lastRecvMessage.acknowledge();
                        break;
                    }
                }
                recvMessage = jmsConsumer.receive(500L);
            }
            Assert.assertEquals((Object)2, (Object)recvMessages.size());
            switch (this.ackMode) {
                case 2: {
                    lastRecvMessage.acknowledge();
                    break;
                }
                case 0: {
                    jmsContext.commit();
                    break;
                }
            }
            jmsConsumer.close();
            int foundCount = 0;
            for (int validDeliveryMode : Arrays.asList(1, 2)) {
                for (Message tmpMessage : recvMessages) {
                    if (tmpMessage.getJMSDeliveryMode() != validDeliveryMode) continue;
                    MessageData messageData = new MessageData();
                    messageData.setMessageType("text").setMessagePayload(this.messagePayload).setDeliveryMode(validDeliveryMode);
                    ActiveMQJMS2TestSupport.validateMessageData(tmpMessage, messageData);
                    ++foundCount;
                }
            }
            Assert.assertEquals((Object)2, (Object)foundCount);
            final DestinationViewMBean destinationViewMBean = this.getDestinationViewMBean(this.destinationType, (ActiveMQDestination)destination);
            Assert.assertTrue((String)"QueueSize = 0 expected", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return destinationViewMBean.getQueueSize() == 0L;
                }
            }, (long)5000L, (long)10L));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

