/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jndi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSslConnectionFactory;
import org.apache.activemq.ActiveMQXASslConnectionFactory;
import org.apache.activemq.jndi.ActiveMQSslInitialContextFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ActiveMQSslInitialContextFactoryTest {
    protected Context context;
    protected boolean isXa;

    @Parameterized.Parameters(name="isXa={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    public ActiveMQSslInitialContextFactoryTest(boolean isXa) {
        this.isXa = isXa;
    }

    @Before
    public void setUp() throws Exception {
        ActiveMQSslInitialContextFactory factory = new ActiveMQSslInitialContextFactory();
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.provider.url", "vm://0");
        environment.put("connection.ConnectionFactory.userName", "user");
        environment.put("connection.ConnectionFactory.userPassword", "test");
        environment.put("connection.ConnectionFactory.keyStore", "keystore.jks");
        environment.put("connection.ConnectionFactory.keyStorePassword", "test");
        environment.put("connection.ConnectionFactory.keyStoreType", "JKS");
        environment.put("connection.ConnectionFactory.trustStore", "truststore.jks");
        environment.put("connection.ConnectionFactory.trustStorePassword", "test");
        environment.put("connection.ConnectionFactory.trustStoreType", "JKS");
        environment.put("xa", Boolean.toString(this.isXa));
        this.context = factory.getInitialContext(environment);
        Assert.assertTrue((String)"No context created", (this.context != null ? 1 : 0) != 0);
    }

    @Test
    public void testCreateXaConnectionFactory() throws NamingException {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.context.lookup("ConnectionFactory");
        Assert.assertTrue((boolean)(factory instanceof ActiveMQSslConnectionFactory));
        if (this.isXa) {
            Assert.assertTrue((boolean)(factory instanceof ActiveMQXASslConnectionFactory));
        } else {
            Assert.assertFalse((boolean)(factory instanceof ActiveMQXASslConnectionFactory));
        }
    }

    @Test
    public void testAssertConnectionFactoryProperties() throws NamingException {
        Object c = this.context.lookup("ConnectionFactory");
        if (c instanceof ActiveMQSslConnectionFactory) {
            ActiveMQSslConnectionFactory factory = (ActiveMQSslConnectionFactory)c;
            Assert.assertEquals((Object)factory.getKeyStore(), (Object)"keystore.jks");
            Assert.assertEquals((Object)factory.getKeyStorePassword(), (Object)"test");
            Assert.assertEquals((Object)factory.getKeyStoreType(), (Object)"JKS");
            Assert.assertEquals((Object)factory.getTrustStore(), (Object)"truststore.jks");
            Assert.assertEquals((Object)factory.getTrustStorePassword(), (Object)"test");
            Assert.assertEquals((Object)factory.getTrustStoreType(), (Object)"JKS");
        } else {
            Assert.fail((String)"Did not find an ActiveMQSslConnectionFactory");
        }
    }
}

