/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.TemporaryQueue;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.network.SimpleNetworkTest;
import org.apache.activemq.util.Wait;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DuplexNetworkTest
extends SimpleNetworkTest {
    private static final Logger LOG = LoggerFactory.getLogger(DuplexNetworkTest.class);

    @Override
    protected String getLocalBrokerURI() {
        return "org/apache/activemq/network/duplexLocalBroker.xml";
    }

    @Override
    protected BrokerService createRemoteBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("remoteBroker");
        broker.addConnector("tcp://localhost:61617?transport.connectAttemptTimeout=2000");
        return broker;
    }

    @Test
    public void testTempQueues() throws Exception {
        TemporaryQueue temp = this.localSession.createTemporaryQueue();
        MessageProducer producer = this.localSession.createProducer((Destination)temp);
        producer.send((Message)this.localSession.createTextMessage("test"));
        Thread.sleep(100L);
        Assert.assertEquals((String)"Destination not created", (long)1L, (long)this.remoteBroker.getAdminView().getTemporaryQueues().length);
        temp.delete();
        Assert.assertTrue((String)"Destination not deleted", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return 0 == DuplexNetworkTest.this.remoteBroker.getAdminView().getTemporaryQueues().length;
            }
        }));
    }

    @Test
    public void testStaysUp() throws Exception {
        int bridgeIdentity = this.getBridgeId();
        LOG.info("Bridges: " + bridgeIdentity);
        TimeUnit.SECONDS.sleep(5L);
        Assert.assertEquals((String)"Same bridges", (long)bridgeIdentity, (long)this.getBridgeId());
    }

    private int getBridgeId() {
        int id = 0;
        while (id == 0) {
            try {
                id = ((NetworkBridge)((NetworkConnector)this.localBroker.getNetworkConnectors().get(0)).activeBridges().iterator().next()).hashCode();
            }
            catch (Throwable tryAgainInABit) {
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return id;
    }

    @Override
    protected void assertNetworkBridgeStatistics(final long expectedLocalSent, final long expectedRemoteSent) throws Exception {
        final NetworkBridge localBridge = (NetworkBridge)((NetworkConnector)this.localBroker.getNetworkConnectors().get(0)).activeBridges().iterator().next();
        Assert.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return expectedLocalSent == localBridge.getNetworkBridgeStatistics().getDequeues().getCount() && expectedRemoteSent == localBridge.getNetworkBridgeStatistics().getReceivedCount().getCount();
            }
        }));
    }
}

