/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.network.ForwardingBridge;
import org.apache.activemq.network.NetworkTestSupport;

public class ForwardingBridgeTest
extends NetworkTestSupport {
    public ActiveMQDestination destination;
    public byte destinationType;
    public int deliveryMode;
    private ForwardingBridge bridge;

    public void initCombosForTestForwardMessageCompressed() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2});
    }

    public void testForwardMessageCompressed() throws Exception {
        this.bridge.setUseCompression(true);
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection1, connectionInfo1, this.destinationType);
        StubConnection connection2 = this.createRemoteConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo2, this.destination);
        connection2.send((Command)consumerInfo);
        Thread.sleep(1000L);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        connection1.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        Message m = this.receiveMessage(connection2);
        ForwardingBridgeTest.assertNotNull((Object)m);
        ActiveMQMessage message = (ActiveMQMessage)m;
        ForwardingBridgeTest.assertTrue((boolean)message.isCompressed());
    }

    public void initCombosForTestAddConsumerThenSend() {
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1, (byte)2});
    }

    public void testAddConsumerThenSend() throws Exception {
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo1);
        connection1.send((Command)connectionInfo1);
        connection1.send((Command)sessionInfo1);
        connection1.send((Command)producerInfo);
        this.destination = this.createDestinationInfo(connection1, connectionInfo1, this.destinationType);
        StubConnection connection2 = this.createRemoteConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        connection2.send((Command)connectionInfo2);
        connection2.send((Command)sessionInfo2);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo2, this.destination);
        connection2.send((Command)consumerInfo);
        Thread.sleep(1000L);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        connection1.send((Command)this.createMessage(producerInfo, this.destination, this.deliveryMode));
        Message m = this.receiveMessage(connection2);
        ForwardingBridgeTest.assertNotNull((Object)m);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.bridge = new ForwardingBridge(this.createTransport(), this.createRemoteTransport());
        this.bridge.setClientId("local-remote-bridge");
        this.bridge.setDispatchAsync(false);
        this.bridge.start();
    }

    @Override
    protected void tearDown() throws Exception {
        this.bridge.stop();
        super.tearDown();
    }

    public static Test suite() {
        return ForwardingBridgeTest.suite(ForwardingBridgeTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ForwardingBridgeTest.suite());
    }
}

