/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.NetworkConnector;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConnectorDefaultsTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkConnectorDefaultsTest.class);
    private static final String LOCAL_BROKER_TRANSPORT_URI = "tcp://localhost:61616";
    private static final String REMOTE_BROKER_TRANSPORT_URI = "tcp://localhost:61617";
    private static final String DESTINATION_NAME = "TEST.RECONNECT";
    private BrokerService localBroker;
    private BrokerService remoteBroker;

    @Test
    public void testDefaultValues() throws Exception {
        LOG.info("testIsStarted is starting...");
        LOG.info("Adding network connector...");
        NetworkConnector nc = this.localBroker.addNetworkConnector("static:(tcp://localhost:61617)");
        nc.setName("NC1");
        NetworkConnectorDefaultsTest.assertEquals((Object)75, (Object)nc.getAdvisoryAckPercentage());
        NetworkConnectorDefaultsTest.assertEquals((Object)0, (Object)nc.getAdvisoryPrefetchSize());
        NetworkConnectorDefaultsTest.assertEquals((Object)-5, (Object)nc.getConsumerPriorityBase());
        NetworkConnectorDefaultsTest.assertEquals((Object)1, (Object)nc.getConsumerTTL());
        NetworkConnectorDefaultsTest.assertEquals((Object)60000L, (Object)nc.getGcSweepTime());
        NetworkConnectorDefaultsTest.assertEquals((Object)1, (Object)nc.getMessageTTL());
        NetworkConnectorDefaultsTest.assertEquals((Object)1, (Object)nc.getNetworkTTL());
        NetworkConnectorDefaultsTest.assertEquals((Object)1000, (Object)nc.getPrefetchSize());
        NetworkConnectorDefaultsTest.assertFalse((boolean)nc.isAdvisoryForFailedForward());
        NetworkConnectorDefaultsTest.assertTrue((boolean)nc.isAlwaysSyncSend());
        NetworkConnectorDefaultsTest.assertTrue((boolean)nc.isBridgeTempDestinations());
        NetworkConnectorDefaultsTest.assertFalse((boolean)nc.isCheckDuplicateMessagesOnDuplex());
        NetworkConnectorDefaultsTest.assertFalse((boolean)nc.isConduitNetworkQueueSubscriptions());
        NetworkConnectorDefaultsTest.assertTrue((boolean)nc.isDecreaseNetworkConsumerPriority());
        NetworkConnectorDefaultsTest.assertTrue((boolean)nc.isDispatchAsync());
        NetworkConnectorDefaultsTest.assertFalse((boolean)nc.isDuplex());
        NetworkConnectorDefaultsTest.assertFalse((boolean)nc.isDynamicOnly());
        NetworkConnectorDefaultsTest.assertTrue((boolean)nc.isGcDestinationViews());
        NetworkConnectorDefaultsTest.assertFalse((boolean)nc.isStaticBridge());
        NetworkConnectorDefaultsTest.assertFalse((boolean)nc.isSuppressDuplicateQueueSubscriptions());
        NetworkConnectorDefaultsTest.assertTrue((boolean)nc.isSuppressDuplicateTopicSubscriptions());
        NetworkConnectorDefaultsTest.assertFalse((boolean)nc.isSyncDurableSubs());
        NetworkConnectorDefaultsTest.assertTrue((boolean)nc.isUseBrokerNamesAsIdSeed());
        NetworkConnectorDefaultsTest.assertFalse((boolean)nc.isUseCompression());
        NetworkConnectorDefaultsTest.assertFalse((boolean)nc.isUseVirtualDestSubs());
    }

    protected void setUp() throws Exception {
        LOG.info("Setting up LocalBroker");
        this.localBroker = new BrokerService();
        this.localBroker.setBrokerName("LocalBroker");
        this.localBroker.setUseJmx(false);
        this.localBroker.setPersistent(false);
        this.localBroker.setTransportConnectorURIs(new String[]{LOCAL_BROKER_TRANSPORT_URI});
        this.localBroker.start();
        this.localBroker.waitUntilStarted();
        LOG.info("Setting up RemoteBroker");
        this.remoteBroker = new BrokerService();
        this.remoteBroker.setBrokerName("RemoteBroker");
        this.remoteBroker.setUseJmx(false);
        this.remoteBroker.setPersistent(false);
        this.remoteBroker.setTransportConnectorURIs(new String[]{REMOTE_BROKER_TRANSPORT_URI});
        this.remoteBroker.start();
        this.remoteBroker.waitUntilStarted();
    }

    protected void tearDown() throws Exception {
        if (this.localBroker.isStarted()) {
            LOG.info("Stopping LocalBroker");
            this.localBroker.stop();
            this.localBroker.waitUntilStopped();
            this.localBroker = null;
        }
        if (this.remoteBroker.isStarted()) {
            LOG.info("Stopping RemoteBroker");
            this.remoteBroker.stop();
            this.remoteBroker.waitUntilStopped();
            this.remoteBroker = null;
        }
    }
}

