/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.proxy;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Session;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.proxy.ProxyConnector;
import org.apache.activemq.util.ConsumerThread;
import org.apache.activemq.util.ProducerThread;

public class ProxyFailoverTest
extends TestCase {
    BrokerService proxyBroker;
    BrokerService remoteBroker;

    protected void setUp() throws Exception {
        this.startRemoteBroker(true);
        this.proxyBroker = new BrokerService();
        ProxyConnector connector = new ProxyConnector();
        connector.setBind(new URI("tcp://localhost:51618"));
        connector.setProxyToLocalBroker(false);
        connector.setRemote(new URI("failover:(tcp://localhost:61616)"));
        this.proxyBroker.addProxyConnector(connector);
        this.proxyBroker.setPersistent(false);
        this.proxyBroker.setUseJmx(false);
        this.proxyBroker.start();
        this.proxyBroker.waitUntilStarted();
    }

    protected void tearDown() throws Exception {
        this.proxyBroker.stop();
        this.proxyBroker.waitUntilStopped();
        this.remoteBroker.stop();
        this.remoteBroker.waitUntilStopped();
    }

    public void testFailover() throws Exception {
        ActiveMQConnectionFactory producerFactory = new ActiveMQConnectionFactory("failover:(tcp://localhost:61616,tcp://localhost:61626)?randomize=false");
        Connection producerConnection = producerFactory.createConnection();
        producerConnection.start();
        Session producerSession = producerConnection.createSession(false, 1);
        ProducerThread producer = new ProducerThread(producerSession, (Destination)producerSession.createQueue("ProxyTest"));
        producer.setSleep(10);
        producer.start();
        ActiveMQConnectionFactory consumerFactory = new ActiveMQConnectionFactory("tcp://localhost:51618");
        Connection consumerConnection = consumerFactory.createConnection();
        consumerConnection.start();
        Session consumerSession = consumerConnection.createSession(false, 1);
        ConsumerThread consumer = new ConsumerThread(consumerSession, (Destination)consumerSession.createQueue("ProxyTest"));
        consumer.start();
        TimeUnit.SECONDS.sleep(15L);
        this.remoteBroker.stop();
        this.remoteBroker.waitUntilStopped();
        this.startRemoteBroker(false);
        producer.join();
        consumer.join();
        ProxyFailoverTest.assertEquals((int)1000, (int)consumer.getReceived());
    }

    protected void startRemoteBroker(boolean delete) throws Exception {
        this.remoteBroker = new BrokerService();
        this.remoteBroker.addConnector("tcp://localhost:61616");
        if (delete) {
            this.remoteBroker.deleteAllMessages();
        }
        this.remoteBroker.setUseJmx(false);
        this.remoteBroker.start();
        this.remoteBroker.waitUntilStarted();
    }
}

