/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.store.SharedFileLocker;
import org.apache.activemq.util.IOHelper;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.MessageLayout;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedFileLockerLoggingTest {
    private static final Logger LOG = LoggerFactory.getLogger(SharedFileLockerLoggingTest.class);
    @Rule
    public TemporaryFolder testFolder;

    public SharedFileLockerLoggingTest() {
        File file = new File(IOHelper.getDefaultDataDirectory());
        file.mkdir();
        this.testFolder = new TemporaryFolder(file);
    }

    @Test
    public void testLogging() throws Exception {
        this.internalLoop(5L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalLoop(long timewait) throws Exception {
        final AtomicInteger logCounts = new AtomicInteger(0);
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)org.apache.logging.log4j.core.Logger.class.cast(LogManager.getRootLogger());
        AbstractAppender appender = new AbstractAppender("testAppender", (Filter)new AbstractFilter(){}, (Layout)new MessageLayout(), false, new Property[0]){

            public void append(LogEvent event) {
                if (event.getLevel() == Level.INFO) {
                    logCounts.incrementAndGet();
                }
            }
        };
        appender.start();
        Configurator.setRootLevel((Level)Level.DEBUG);
        logger.get().addAppender((Appender)appender, Level.DEBUG, (Filter)new AbstractFilter(){});
        logger.addAppender((Appender)appender);
        final AtomicInteger errors = new AtomicInteger(0);
        Thread thread = null;
        SharedFileLocker locker1 = new SharedFileLocker();
        locker1.setDirectory(this.testFolder.getRoot());
        final SharedFileLocker locker2 = new SharedFileLocker();
        locker2.setLockAcquireSleepInterval(1L);
        locker2.setDirectory(this.testFolder.getRoot());
        try {
            locker1.doStart();
            Assert.assertTrue((boolean)locker1.keepAlive());
            thread = new Thread("Locker Thread"){

                @Override
                public void run() {
                    try {
                        locker2.doStart();
                    }
                    catch (Throwable e) {
                        errors.incrementAndGet();
                    }
                }
            };
            thread.start();
            long timeout = System.currentTimeMillis() + 5000L;
            while (logCounts.get() < 1 && System.currentTimeMillis() < timeout) {
                Thread.sleep(1L);
            }
            if (timewait > 0L) {
                Thread.sleep(timewait);
            }
            Assert.assertTrue((boolean)thread.isAlive());
            locker1.stop();
            thread.join(5000L);
            Assert.assertEquals((String)"Extra logs in place", (long)1L, (long)logCounts.get());
            timeout = System.currentTimeMillis() + 5000L;
            while (timeout > System.currentTimeMillis() && !locker2.keepAlive()) {
                Thread.sleep(1L);
            }
            Assert.assertTrue((boolean)locker2.keepAlive());
            locker2.stop();
            Assert.assertEquals((long)0L, (long)errors.get());
        }
        finally {
            logger.removeAppender((Appender)appender);
            thread.join(1000L);
            if (thread.isAlive()) {
                thread.interrupt();
            }
            File lockFile = new File(this.testFolder.getRoot(), "lock");
            lockFile.delete();
        }
    }
}

