/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.AbstractVmConcurrentDispatchTest;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class KahaDbVmConcurrentDispatchTest
extends AbstractVmConcurrentDispatchTest {
    private final boolean concurrentDispatch;
    private static boolean[] concurrentDispatchVals = booleanVals;

    @Parameterized.Parameters(name="Type:{0}; ReduceMemoryFootPrint:{1}; ConcurrentDispatch:{2}; UseTopic:{3}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> values = new ArrayList<Object[]>();
        for (AbstractVmConcurrentDispatchTest.MessageType mt : AbstractVmConcurrentDispatchTest.MessageType.values()) {
            for (boolean rmfVal : reduceMemoryFootPrintVals) {
                for (boolean cdVal : concurrentDispatchVals) {
                    for (boolean tpVal : useTopicVals) {
                        values.add(new Object[]{mt, rmfVal, cdVal, tpVal});
                    }
                }
            }
        }
        return values;
    }

    public KahaDbVmConcurrentDispatchTest(AbstractVmConcurrentDispatchTest.MessageType messageType, boolean reduceMemoryFootPrint, boolean concurrentDispatch, boolean useTopic) {
        super(messageType, reduceMemoryFootPrint, useTopic);
        this.concurrentDispatch = concurrentDispatch;
    }

    @Override
    protected void configurePersistenceAdapter(BrokerService broker) throws IOException {
        KahaDBPersistenceAdapter ad = (KahaDBPersistenceAdapter)broker.getPersistenceAdapter();
        if (this.useTopic) {
            ad.setConcurrentStoreAndDispatchTopics(this.concurrentDispatch);
        } else {
            ad.setConcurrentStoreAndDispatchQueues(this.concurrentDispatch);
        }
    }
}

