/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvisoryTopicDeletionTest
extends TestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AdvisoryTopicDeletionTest.class);
    private BrokerService broker;
    private Connection connection;

    @Override
    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://" + this.getName());
    }

    protected void setUp() throws Exception {
        this.createBroker();
        this.topic = false;
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.destroyBroker();
    }

    private void createBroker() throws Exception {
        this.broker = BrokerFactory.createBroker((String)"broker:(vm://localhost)");
        this.broker.setPersistent(false);
        this.broker.setBrokerName(this.getName());
        this.broker.start();
        this.connection = this.createConnection();
    }

    @Override
    protected Connection createConnection() throws Exception {
        Connection con = super.createConnection();
        con.start();
        return con;
    }

    private void destroyBroker() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public void doTest() throws Exception {
        Destination dest = this.createDestination();
        Session producerSession = this.connection.createSession(false, 1);
        Session consumerSession = this.connection.createSession(false, 1);
        MessageConsumer consumer = consumerSession.createConsumer(dest);
        MessageProducer prod = producerSession.createProducer(dest);
        Message message = producerSession.createMessage();
        prod.send(message);
        consumer.receive(60000L);
        this.connection.close();
        this.connection = null;
        if (this.topic) {
            this.broker.getAdminView().removeTopic(((ActiveMQDestination)dest).getPhysicalName());
        } else {
            this.broker.getAdminView().removeQueue(((ActiveMQDestination)dest).getPhysicalName());
        }
        ActiveMQDestination[] dests = this.broker.getRegionBroker().getDestinations();
        int matchingDestinations = 0;
        for (ActiveMQDestination destination : dests) {
            String name = destination.getPhysicalName();
            LOG.debug("Found destination " + name);
            if (!name.startsWith("ActiveMQ.Advisory") || !name.contains(this.getDestinationString())) continue;
            ++matchingDestinations;
        }
        AdvisoryTopicDeletionTest.assertEquals((String)"No matching destinations should be found", (int)0, (int)matchingDestinations);
    }

    public void testTopic() throws Exception {
        this.topic = true;
        this.doTest();
    }

    public void testQueue() throws Exception {
        this.topic = false;
        this.doTest();
    }
}

