/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.net.URI;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.command.ActiveMQMessage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumeUncompressedCompressedMessageTest {
    private static final Logger LOG = LoggerFactory.getLogger(ConsumeUncompressedCompressedMessageTest.class);
    private BrokerService broker;
    private URI tcpUri;
    ActiveMQConnectionFactory factory;
    ActiveMQConnection connection;
    Session session;
    Queue queue;

    @Before
    public void setUp() throws Exception {
        this.broker = this.createBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
        this.factory = new ActiveMQConnectionFactory(this.tcpUri);
        this.factory.setUseCompression(true);
        this.connection = (ActiveMQConnection)this.factory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.queue = this.session.createQueue("CompressionTestQueue");
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    protected BrokerService createBroker() throws Exception {
        return this.createBroker(true);
    }

    protected BrokerService createBroker(boolean delete) throws Exception {
        BrokerService answer = new BrokerService();
        answer.setPersistent(false);
        answer.setDeleteAllMessagesOnStartup(true);
        answer.setSchedulerSupport(false);
        answer.setUseJmx(true);
        TransportConnector connector = answer.addConnector("tcp://localhost:0");
        this.tcpUri = connector.getConnectUri();
        return answer;
    }

    @Test
    public void testBrowseAndReceiveCompressedMessages() throws Exception {
        Assert.assertTrue((boolean)this.connection.isUseCompression());
        this.createProducerAndSendMessages(1);
        QueueViewMBean queueView = this.getProxyToQueueViewMBean();
        Assert.assertNotNull((Object)queueView);
        CompositeData[] compdatalist = queueView.browse();
        if (compdatalist.length == 0) {
            Assert.fail((String)"There is no message in the queue:");
        }
        CompositeData cdata = compdatalist[0];
        this.assertComplexData(0, cdata, "Text", "Test Text Message: 0");
        this.assertMessageAreCorrect(1);
    }

    @Test
    public void testReceiveAndResendWithCompressionOff() throws Exception {
        Assert.assertTrue((boolean)this.connection.isUseCompression());
        this.createProducerAndSendMessages(1);
        MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);
        TextMessage message = (TextMessage)consumer.receive(5000L);
        Assert.assertTrue((boolean)((ActiveMQMessage)message).isCompressed());
        LOG.debug("Received Message with Text = " + message.getText());
        this.connection.setUseCompression(false);
        MessageProducer producer = this.session.createProducer((Destination)this.queue);
        producer.send((Message)message);
        producer.close();
        message = (TextMessage)consumer.receive(5000L);
        LOG.debug("Received Message with Text = " + message.getText());
    }

    protected void assertComplexData(int messageIndex, CompositeData cdata, String name, Object expected) {
        Object value = cdata.get(name);
        Assert.assertEquals((String)("Message " + messageIndex + " CData field: " + name), (Object)expected, (Object)value);
    }

    private void createProducerAndSendMessages(int numToSend) throws Exception {
        this.session = this.connection.createSession(false, 2);
        MessageProducer producer = this.session.createProducer((Destination)this.queue);
        for (int i = 0; i < numToSend; ++i) {
            TextMessage message = this.session.createTextMessage("Test Text Message: " + i);
            if (i != 0 && i % 10000 == 0) {
                LOG.info("sent: " + i);
            }
            producer.send((Message)message);
        }
        producer.close();
    }

    private QueueViewMBean getProxyToQueueViewMBean() throws MalformedObjectNameException, JMSException {
        ObjectName queueViewMBeanName = new ObjectName("org.apache.activemq:destinationType=Queue,destinationName=" + this.queue.getQueueName() + ",type=Broker,brokerName=localhost");
        QueueViewMBean proxy = (QueueViewMBean)this.broker.getManagementContext().newProxyInstance(queueViewMBeanName, QueueViewMBean.class, true);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertMessageAreCorrect(int numToReceive) throws Exception {
        try (MessageConsumer consumer = this.session.createConsumer((Destination)this.queue);){
            for (int i = 0; i < numToReceive; ++i) {
                TextMessage message = (TextMessage)consumer.receive(5000L);
                Assert.assertNotNull((Object)message);
                Assert.assertEquals((Object)("Test Text Message: " + i), (Object)message.getText());
            }
        }
    }
}

