/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Connection;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.net.URI;
import javax.management.ObjectName;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.network.DiscoveryNetworkConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.network.NetworkTestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurableSubInBrokerNetworkTest
extends NetworkTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DurableSubInBrokerNetworkTest.class);
    private final String subName = "Subscriber1";
    private final String subName2 = "Subscriber2";
    private final String topicName = "TEST.FOO";

    @Override
    protected void setUp() throws Exception {
        this.useJmx = true;
        super.setUp();
        URI ncUri = new URI("static:(" + this.connector.getConnectUri().toString() + ")");
        DiscoveryNetworkConnector nc = new DiscoveryNetworkConnector(ncUri);
        nc.setDuplex(true);
        this.remoteBroker.addNetworkConnector((NetworkConnector)nc);
        nc.start();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.remoteBroker.isStarted()) {
            this.remoteBroker.stop();
            this.remoteBroker.waitUntilStopped();
        }
        if (this.broker.isStarted()) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
        super.tearDown();
    }

    public void testDurableSubNetwork() throws Exception {
        LOG.info("testDurableSubNetwork started.");
        ActiveMQConnectionFactory fact = new ActiveMQConnectionFactory(this.connector.getConnectUri().toString());
        Connection conn = fact.createConnection();
        conn.setClientID("clientID1");
        Session session = conn.createSession(false, 1);
        Topic dest = session.createTopic("TEST.FOO");
        TopicSubscriber sub = session.createDurableSubscriber(dest, "Subscriber1");
        LOG.info("Durable subscription of name Subscriber1created.");
        Thread.sleep(100L);
        DurableSubInBrokerNetworkTest.assertTrue((boolean)this.foundSubInLocalBroker("Subscriber1"));
        DurableSubInBrokerNetworkTest.assertTrue((boolean)this.foundSubInRemoteBrokerByTopicName("TEST.FOO"));
        sub.close();
        session.unsubscribe("Subscriber1");
        LOG.info("Unsubscribed from durable subscription.");
        Thread.sleep(100L);
        DurableSubInBrokerNetworkTest.assertFalse((boolean)this.foundSubInLocalBroker("Subscriber1"));
        DurableSubInBrokerNetworkTest.assertFalse((String)"Durable subscription not unregistered on remote broker", (boolean)this.foundSubInRemoteBrokerByTopicName("TEST.FOO"));
    }

    public void testTwoDurableSubsInNetworkWithUnsubscribe() throws Exception {
        ActiveMQConnectionFactory fact = new ActiveMQConnectionFactory(this.connector.getConnectUri().toString());
        Connection conn = fact.createConnection();
        conn.setClientID("clientID1");
        Session session = conn.createSession(false, 1);
        Topic dest = session.createTopic("TEST.FOO");
        TopicSubscriber sub = session.createDurableSubscriber(dest, "Subscriber1");
        LOG.info("Durable subscription of name Subscriber1created.");
        TopicSubscriber sub2 = session.createDurableSubscriber(dest, "Subscriber2");
        LOG.info("Durable subscription of name Subscriber2created.");
        Thread.sleep(100L);
        DurableSubInBrokerNetworkTest.assertTrue((boolean)this.foundSubInLocalBroker("Subscriber1"));
        DurableSubInBrokerNetworkTest.assertTrue((boolean)this.foundSubInLocalBroker("Subscriber2"));
        DurableSubInBrokerNetworkTest.assertTrue((boolean)this.foundSubInRemoteBrokerByTopicName("TEST.FOO"));
        sub.close();
        session.unsubscribe("Subscriber1");
        LOG.info("Unsubscribed from durable subscription.");
        Thread.sleep(100L);
        DurableSubInBrokerNetworkTest.assertFalse((boolean)this.foundSubInLocalBroker("Subscriber1"));
        DurableSubInBrokerNetworkTest.assertTrue((boolean)this.foundSubInLocalBroker("Subscriber2"));
        DurableSubInBrokerNetworkTest.assertTrue((String)"Durable subscription should still be on remote broker", (boolean)this.foundSubInRemoteBrokerByTopicName("TEST.FOO"));
        sub2.close();
        session.unsubscribe("Subscriber2");
        Thread.sleep(100L);
        DurableSubInBrokerNetworkTest.assertFalse((boolean)this.foundSubInLocalBroker("Subscriber2"));
        DurableSubInBrokerNetworkTest.assertFalse((String)"Durable subscription not unregistered on remote broker", (boolean)this.foundSubInRemoteBrokerByTopicName("TEST.FOO"));
    }

    private boolean foundSubInRemoteBrokerByTopicName(String topicName) throws Exception {
        boolean foundSub = false;
        ObjectName[] subs = this.remoteBroker.getAdminView().getDurableTopicSubscribers();
        for (int i = 0; i < subs.length; ++i) {
            if (!subs[i].toString().contains("destinationName=" + topicName)) continue;
            foundSub = true;
        }
        return foundSub;
    }

    private boolean foundSubInLocalBroker(String subName) throws Exception {
        boolean foundSub = false;
        ObjectName[] subs = this.broker.getAdminView().getDurableTopicSubscribers();
        for (int i = 0; i < subs.length; ++i) {
            if (!subs[i].toString().contains(subName)) continue;
            foundSub = true;
        }
        return foundSub;
    }
}

