/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.net.URI;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurableSubscriptionUpdatesTest {
    private static final Logger LOG = LoggerFactory.getLogger(DurableSubscriptionUpdatesTest.class);
    private final int MSG_COUNT = 5;
    private BrokerService brokerService;
    private URI connectionUri;
    private String clientId;
    private String subscriptionName;
    private String topicName;
    private TopicConnection connection;
    @Rule
    public TestName name = new TestName();

    protected TopicConnection createConnection() throws JMSException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectionUri);
        factory.setUseAsyncSend(true);
        TopicConnection connection = factory.createTopicConnection();
        connection.setClientID(this.clientId);
        connection.start();
        return connection;
    }

    @Before
    public void setUp() throws Exception {
        this.startBroker();
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stopBroker();
    }

    @Test(timeout=60000L)
    public void testSelectorChange() throws Exception {
        Message message;
        this.connection = this.createConnection();
        TopicSession session = this.connection.createTopicSession(false, 1);
        Topic topic = session.createTopic(this.topicName);
        TopicSubscriber durableSubscriber = session.createDurableSubscriber(topic, this.subscriptionName, "JMSPriority > 8", false);
        this.publishToTopic(session, topic, 9);
        this.publishToTopic(session, topic, 8);
        for (int i = 0; i < 5; ++i) {
            message = durableSubscriber.receive(2000L);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((long)9L, (long)message.getJMSPriority());
        }
        Message message2 = durableSubscriber.receive(500L);
        Assert.assertNull((Object)message2);
        this.publishToTopic(session, topic, 9);
        Assert.assertEquals((long)1L, (long)this.brokerService.getAdminView().getDurableTopicSubscribers().length);
        Assert.assertEquals((long)0L, (long)this.brokerService.getAdminView().getInactiveDurableTopicSubscribers().length);
        durableSubscriber.close();
        Assert.assertTrue((String)"Should have no durables.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return DurableSubscriptionUpdatesTest.this.brokerService.getAdminView().getDurableTopicSubscribers().length == 0;
            }
        }));
        Assert.assertTrue((String)"Should have an inactive sub.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return DurableSubscriptionUpdatesTest.this.brokerService.getAdminView().getInactiveDurableTopicSubscribers().length == 1;
            }
        }));
        LOG.debug("Testing that updated selector subscription does get any messages.");
        durableSubscriber = session.createDurableSubscriber(topic, this.subscriptionName, "JMSPriority > 7", false);
        Assert.assertEquals((long)1L, (long)this.brokerService.getAdminView().getDurableTopicSubscribers().length);
        Assert.assertEquals((long)0L, (long)this.brokerService.getAdminView().getInactiveDurableTopicSubscribers().length);
        message2 = durableSubscriber.receive(500L);
        Assert.assertNull((Object)message2);
        this.publishToTopic(session, topic, 8);
        for (int i = 0; i < 5; ++i) {
            message = durableSubscriber.receive(5000L);
            Assert.assertNotNull((String)"Should get messages now", (Object)message);
            Assert.assertEquals((long)8L, (long)message.getJMSPriority());
        }
    }

    @Test(timeout=60000L)
    public void testResubscribeWithNewNoLocalValueNoBrokerRestart() throws Exception {
        Message message;
        this.connection = this.createConnection();
        TopicSession session = this.connection.createTopicSession(false, 1);
        Topic topic = session.createTopic(this.topicName);
        TopicSubscriber durableSubscriber = session.createDurableSubscriber(topic, this.subscriptionName, null, true);
        TopicSubscriber nonDurableSubscriber = session.createSubscriber(topic);
        this.publishToTopic(session, topic);
        LOG.debug("Testing that noLocal=true subscription doesn't get any messages.");
        for (int i = 0; i < 5; ++i) {
            message = nonDurableSubscriber.receive(2000L);
            Assert.assertNotNull((Object)message);
        }
        Message message2 = durableSubscriber.receive(500L);
        Assert.assertNull((Object)message2);
        this.publishToTopic(session, topic);
        Assert.assertEquals((long)1L, (long)this.brokerService.getAdminView().getDurableTopicSubscribers().length);
        Assert.assertEquals((long)0L, (long)this.brokerService.getAdminView().getInactiveDurableTopicSubscribers().length);
        durableSubscriber.close();
        Assert.assertTrue((String)"Should have no durables.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return DurableSubscriptionUpdatesTest.this.brokerService.getAdminView().getDurableTopicSubscribers().length == 0;
            }
        }));
        Assert.assertTrue((String)"Should have an inactive sub.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return DurableSubscriptionUpdatesTest.this.brokerService.getAdminView().getInactiveDurableTopicSubscribers().length == 1;
            }
        }));
        LOG.debug("Testing that updated noLocal=false subscription does get any messages.");
        durableSubscriber = session.createDurableSubscriber(topic, this.subscriptionName, null, false);
        Assert.assertEquals((long)1L, (long)this.brokerService.getAdminView().getDurableTopicSubscribers().length);
        Assert.assertEquals((long)0L, (long)this.brokerService.getAdminView().getInactiveDurableTopicSubscribers().length);
        message2 = durableSubscriber.receive(500L);
        Assert.assertNull((Object)message2);
        this.publishToTopic(session, topic);
        for (int i = 0; i < 5; ++i) {
            message = durableSubscriber.receive(5000L);
            Assert.assertNotNull((String)"Should get local messages now", (Object)message);
        }
    }

    @Test(timeout=60000L)
    public void testDurableResubscribeWithNewNoLocalValueWithBrokerRestart() throws Exception {
        Message message;
        this.connection = this.createConnection();
        TopicSession session = this.connection.createTopicSession(false, 1);
        Topic topic = session.createTopic(this.topicName);
        TopicSubscriber durableSubscriber = session.createDurableSubscriber(topic, this.subscriptionName, null, true);
        TopicSubscriber nonDurableSubscriber = session.createSubscriber(topic);
        this.publishToTopic(session, topic);
        LOG.debug("Testing that noLocal=true subscription doesn't get any messages.");
        for (int i = 0; i < 5; ++i) {
            message = nonDurableSubscriber.receive(2000L);
            Assert.assertNotNull((Object)message);
        }
        Message message2 = durableSubscriber.receive(500L);
        Assert.assertNull((Object)message2);
        this.publishToTopic(session, topic);
        Assert.assertEquals((long)1L, (long)this.brokerService.getAdminView().getDurableTopicSubscribers().length);
        Assert.assertEquals((long)0L, (long)this.brokerService.getAdminView().getInactiveDurableTopicSubscribers().length);
        durableSubscriber.close();
        Assert.assertTrue((String)"Should have no durables.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return DurableSubscriptionUpdatesTest.this.brokerService.getAdminView().getDurableTopicSubscribers().length == 0;
            }
        }));
        Assert.assertTrue((String)"Should have an inactive sub.", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return DurableSubscriptionUpdatesTest.this.brokerService.getAdminView().getInactiveDurableTopicSubscribers().length == 1;
            }
        }));
        LOG.debug("Testing that updated noLocal=false subscription does get any messages.");
        this.connection.close();
        this.restartBroker();
        this.connection = this.createConnection();
        session = this.connection.createTopicSession(false, 1);
        Assert.assertEquals((long)0L, (long)this.brokerService.getAdminView().getDurableTopicSubscribers().length);
        Assert.assertEquals((long)1L, (long)this.brokerService.getAdminView().getInactiveDurableTopicSubscribers().length);
        durableSubscriber = session.createDurableSubscriber(topic, this.subscriptionName, null, false);
        Assert.assertEquals((long)1L, (long)this.brokerService.getAdminView().getDurableTopicSubscribers().length);
        Assert.assertEquals((long)0L, (long)this.brokerService.getAdminView().getInactiveDurableTopicSubscribers().length);
        message2 = durableSubscriber.receive(500L);
        Assert.assertNull((Object)message2);
        this.publishToTopic(session, topic);
        for (int i = 0; i < 5; ++i) {
            message = durableSubscriber.receive(2000L);
            Assert.assertNotNull((String)"Should get local messages now", (Object)message);
        }
    }

    private void publishToTopic(TopicSession session, Topic destination) throws Exception {
        this.publishToTopic(session, destination, 4);
    }

    private void publishToTopic(TopicSession session, Topic destination, int priority) throws Exception {
        TopicPublisher publisher = session.createPublisher(destination);
        for (int i = 0; i < 5; ++i) {
            publisher.send(session.createMessage(), 2, priority, 0L);
        }
        publisher.close();
    }

    private void startBroker() throws Exception {
        this.createBroker(true);
    }

    private void restartBroker() throws Exception {
        this.stopBroker();
        this.createBroker(false);
    }

    private void stopBroker() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
            this.brokerService = null;
        }
    }

    private void createBroker(boolean deleteMessages) throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setUseJmx(true);
        this.brokerService.getManagementContext().setCreateMBeanServer(false);
        this.brokerService.setPersistent(true);
        this.brokerService.setDeleteAllMessagesOnStartup(deleteMessages);
        this.brokerService.setAdvisorySupport(false);
        this.brokerService.setSchedulerSupport(false);
        this.brokerService.setKeepDurableSubsActive(false);
        TransportConnector connector = this.brokerService.addConnector("tcp://0.0.0.0:0");
        this.brokerService.start();
        this.connectionUri = connector.getPublishableConnectURI();
        this.clientId = this.name.getMethodName() + "-ClientId";
        this.subscriptionName = this.name.getMethodName() + "-Subscription";
        this.topicName = this.name.getMethodName();
    }
}

