/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Destination;
import jakarta.jms.Session;
import java.util.Set;
import org.apache.activemq.EmbeddedBrokerAndConnectionTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewConsumerCreatesDestinationTest
extends EmbeddedBrokerAndConnectionTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(NewConsumerCreatesDestinationTest.class);
    private ActiveMQQueue wildcard;

    public void testNewConsumerCausesNewDestinationToBeAutoCreated() throws Exception {
        String wildcardText = "org.*" + this.getDestinationString().substring("org.apache".length());
        this.wildcard = new ActiveMQQueue(wildcardText);
        LOG.info("Using wildcard: " + this.wildcard);
        LOG.info("on destination: " + this.destination);
        this.assertDestinationCreated((Destination)this.destination, false);
        this.assertDestinationCreated((Destination)this.wildcard, false);
        Session session = this.connection.createSession(false, 1);
        session.createConsumer((Destination)this.destination);
        this.assertDestinationCreated((Destination)this.destination, true);
        this.assertDestinationCreated((Destination)this.wildcard, true);
    }

    protected void assertDestinationCreated(Destination destination, boolean expected) throws Exception {
        Set answer = this.broker.getBroker().getDestinations((ActiveMQDestination)destination);
        int size = expected ? 1 : 0;
        NewConsumerCreatesDestinationTest.assertEquals((String)("Size of found destinations: " + answer), (int)size, (int)answer.size());
    }
}

