/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.activemq.JmsMultipleBrokersTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.broker.region.virtual.VirtualTopic;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.kahadb.KahaDBStore;
import org.apache.activemq.util.MessageIdList;

public class TwoBrokerVirtualDestDinamicallyIncludedDestTest
extends JmsMultipleBrokersTestSupport {
    protected static final int MESSAGE_COUNT = 10;
    boolean dynamicOnly = true;
    int networkTTL = 1;
    boolean conduit = true;
    boolean suppressDuplicateQueueSubscriptions = true;
    boolean decreaseNetworkConsumerPriority = true;

    public void testTopicDinamicallyIncludedBehavior() throws Exception {
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("test", true);
        MessageConsumer clientA = this.createConsumer("BrokerA", (Destination)dest);
        MessageConsumer clientB = this.createConsumer("BrokerB", (Destination)dest);
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", (Destination)dest, 10);
        MessageIdList msgsA = this.getConsumerMessages("BrokerA", clientA);
        msgsA.waitForMessagesToArrive(10);
        TwoBrokerVirtualDestDinamicallyIncludedDestTest.assertEquals((int)10, (int)msgsA.getMessageCount());
        MessageIdList msgsB = this.getConsumerMessages("BrokerB", clientB);
        msgsB.waitForMessagesToArrive(10);
        TwoBrokerVirtualDestDinamicallyIncludedDestTest.assertEquals((int)0, (int)msgsB.getMessageCount());
    }

    public void testVirtualDestinationsDinamicallyIncludedBehavior1() throws Exception {
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("global.test", true);
        MessageConsumer clientB1 = this.createConsumer("BrokerB", (Destination)dest);
        MessageConsumer clientB2 = this.createConsumer("BrokerB", (Destination)this.createDestination("Consumer.foo-bar.global.test", false));
        Thread.sleep(2000L);
        int messageCount = 10;
        this.sendMessages("BrokerA", (Destination)dest, messageCount);
        MessageIdList msgsB1 = this.getConsumerMessages("BrokerB", clientB1);
        msgsB1.waitForMessagesToArrive(messageCount);
        TwoBrokerVirtualDestDinamicallyIncludedDestTest.assertEquals((int)messageCount, (int)msgsB1.getMessageCount());
        MessageIdList msgsB2 = this.getConsumerMessages("BrokerB", clientB2);
        msgsB2.waitForMessagesToArrive(messageCount);
        TwoBrokerVirtualDestDinamicallyIncludedDestTest.assertEquals((int)messageCount, (int)msgsB2.getMessageCount());
    }

    public void testVirtualDestinationsDinamicallyIncludedBehavior2() throws Exception {
        this.startAllBrokers();
        ActiveMQDestination dest = this.createDestination("global.test", true);
        MessageConsumer clientB2 = this.createConsumer("BrokerB", (Destination)this.createDestination("Consumer.foo-bar.global.test", false));
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", (Destination)dest, 10);
        MessageIdList msgsB2 = this.getConsumerMessages("BrokerB", clientB2);
        msgsB2.waitForMessagesToArrive(10);
        TwoBrokerVirtualDestDinamicallyIncludedDestTest.assertEquals((int)10, (int)msgsB2.getMessageCount());
    }

    public void testVirtualDestinationsDinamicallyIncludedBehavior3() throws Exception {
        String topic = "global.test";
        String vq = "Consumer.foo.global.test";
        this.startAllBrokers();
        int msgs1 = 1001;
        int msgs2 = 1456;
        ActiveMQDestination tDest = this.createDestination("global.test", true);
        ActiveMQDestination vqDest = this.createDestination("Consumer.foo.global.test", false);
        MessageConsumer clientB1t = this.createConsumer("BrokerA", (Destination)tDest);
        MessageConsumer clientB2t = this.createConsumer("BrokerB", (Destination)tDest);
        MessageConsumer clientB1vq = this.createConsumer("BrokerA", (Destination)vqDest);
        Thread.sleep(2000L);
        this.sendMessages("BrokerA", (Destination)tDest, 1001);
        this.sendMessages("BrokerB", (Destination)tDest, 1456);
        Thread.sleep(5000L);
        MessageIdList msgsB1t = this.getConsumerMessages("BrokerA", clientB1t);
        msgsB1t.waitForMessagesToArrive(2457);
        TwoBrokerVirtualDestDinamicallyIncludedDestTest.assertEquals((int)2457, (int)msgsB1t.getMessageCount());
        MessageIdList msgsB2t = this.getConsumerMessages("BrokerB", clientB2t);
        msgsB2t.waitForMessagesToArrive(2457);
        TwoBrokerVirtualDestDinamicallyIncludedDestTest.assertEquals((int)2457, (int)msgsB2t.getMessageCount());
        MessageIdList msgsB1vq = this.getConsumerMessages("BrokerA", clientB1vq);
        msgsB1vq.waitForMessagesToArrive(2457);
        TwoBrokerVirtualDestDinamicallyIncludedDestTest.assertEquals((int)2457, (int)msgsB1vq.getMessageCount());
        TwoBrokerVirtualDestDinamicallyIncludedDestTest.assertEquals((long)0L, (long)this.getQueueSize("BrokerA", vqDest));
        TwoBrokerVirtualDestDinamicallyIncludedDestTest.assertEquals((long)0L, (long)this.getQueueSize("BrokerB", vqDest));
        this.destroyAllBrokers();
    }

    public long getQueueSize(String broker, ActiveMQDestination destination) throws Exception {
        JmsMultipleBrokersTestSupport.BrokerItem bi = (JmsMultipleBrokersTestSupport.BrokerItem)this.brokers.get(broker);
        return bi.broker.getDestination(destination).getDestinationStatistics().getMessages().getCount();
    }

    @Override
    public void setUp() throws Exception {
        super.setAutoFail(true);
        super.setUp();
        String options = new String("?useJmx=false&deleteAllMessagesOnStartup=true");
        this.createAndConfigureBroker(new URI("broker:(tcp://localhost:61616)/BrokerA" + options));
        this.createAndConfigureBroker(new URI("broker:(tcp://localhost:61617)/BrokerB" + options));
        NetworkConnector nc1 = this.bridgeBrokers("BrokerA", "BrokerB", this.dynamicOnly, this.networkTTL, this.conduit);
        nc1.setDecreaseNetworkConsumerPriority(this.decreaseNetworkConsumerPriority);
        nc1.setSuppressDuplicateQueueSubscriptions(this.suppressDuplicateQueueSubscriptions);
        nc1.addStaticallyIncludedDestination(ActiveMQDestination.createDestination((String)"global.>", (byte)2));
        nc1.addDynamicallyIncludedDestination(ActiveMQDestination.createDestination((String)"global.>", (byte)1));
        nc1.addDynamicallyIncludedDestination(ActiveMQDestination.createDestination((String)"global.>", (byte)2));
        nc1.addDynamicallyIncludedDestination(ActiveMQDestination.createDestination((String)"Consumer.*.global.>", (byte)1));
        NetworkConnector nc2 = this.bridgeBrokers("BrokerB", "BrokerA", this.dynamicOnly, this.networkTTL, this.conduit);
        nc2.setDecreaseNetworkConsumerPriority(this.decreaseNetworkConsumerPriority);
        nc2.setSuppressDuplicateQueueSubscriptions(this.suppressDuplicateQueueSubscriptions);
        nc2.addStaticallyIncludedDestination(ActiveMQDestination.createDestination((String)"global.>", (byte)2));
        nc2.addDynamicallyIncludedDestination(ActiveMQDestination.createDestination((String)"global.>", (byte)1));
        nc2.addDynamicallyIncludedDestination(ActiveMQDestination.createDestination((String)"global.>", (byte)2));
        nc2.addDynamicallyIncludedDestination(ActiveMQDestination.createDestination((String)"Consumer.*.global.>", (byte)1));
    }

    private BrokerService createAndConfigureBroker(URI uri) throws Exception {
        BrokerService broker = this.createBroker(uri);
        this.configurePersistenceAdapter(broker);
        VirtualDestinationInterceptor virtualDestinationInterceptor = new VirtualDestinationInterceptor();
        VirtualTopic vTopic = new VirtualTopic();
        vTopic.setLocal(true);
        virtualDestinationInterceptor.setVirtualDestinations(new VirtualDestination[]{vTopic});
        DestinationInterceptor[] destinationInterceptors = new DestinationInterceptor[]{virtualDestinationInterceptor};
        broker.setDestinationInterceptors(destinationInterceptors);
        return broker;
    }

    protected void configurePersistenceAdapter(BrokerService broker) throws IOException {
        File dataFileDir = new File("target/test-amq-data/kahadb/" + broker.getBrokerName());
        KahaDBStore kaha = new KahaDBStore();
        kaha.setDirectory(dataFileDir);
        kaha.deleteAllMessages();
        broker.setPersistenceAdapter((PersistenceAdapter)kaha);
    }
}

