/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.quorum.zookeeper;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.quorum.DistributedLock;
import org.apache.activemq.artemis.quorum.UnavailableStateException;
import org.apache.activemq.artemis.quorum.zookeeper.CuratorDistributedPrimitive;
import org.apache.activemq.artemis.quorum.zookeeper.CuratorDistributedPrimitiveManager;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreV2;
import org.apache.curator.framework.recipes.locks.Lease;

final class CuratorDistributedLock
extends CuratorDistributedPrimitive
implements DistributedLock {
    private final InterProcessSemaphoreV2 ipcSem;
    private final CopyOnWriteArrayList<DistributedLock.UnavailableLockListener> listeners;
    private Lease lease;
    private byte[] leaseVersion;

    CuratorDistributedLock(CuratorDistributedPrimitiveManager.PrimitiveId id, CuratorDistributedPrimitiveManager manager, InterProcessSemaphoreV2 ipcSem) {
        super(id, manager);
        this.ipcSem = ipcSem;
        this.listeners = new CopyOnWriteArrayList();
        this.leaseVersion = null;
    }

    @Override
    protected void handleReconnected() {
        super.handleReconnected();
        if (this.leaseVersion != null) {
            assert (this.lease != null);
            try {
                if (Arrays.equals(this.lease.getData(), this.leaseVersion)) {
                    return;
                }
                this.onLost();
            }
            catch (Exception e) {
                this.onLost();
            }
        }
    }

    @Override
    protected void handleLost() {
        super.handleLost();
        this.lease = null;
        this.leaseVersion = null;
        for (DistributedLock.UnavailableLockListener listener : this.listeners) {
            listener.onUnavailableLockEvent();
        }
    }

    public String getLockId() {
        return this.getId().id;
    }

    public boolean isHeldByCaller() throws UnavailableStateException {
        return this.run(() -> {
            this.checkUnavailable();
            if (this.lease == null) {
                return false;
            }
            assert (this.leaseVersion != null);
            try {
                return Arrays.equals(this.lease.getData(), this.leaseVersion);
            }
            catch (Throwable t) {
                throw new UnavailableStateException(t);
            }
        });
    }

    public boolean tryLock() throws UnavailableStateException, InterruptedException {
        return this.tryRun(() -> {
            if (this.lease != null) {
                throw new IllegalStateException("unlock first");
            }
            this.checkUnavailable();
            try {
                byte[] leaseVersion = UUID.randomUUID().toString().getBytes(StandardCharsets.UTF_8);
                this.ipcSem.setNodeData(leaseVersion);
                this.lease = this.ipcSem.acquire(0L, TimeUnit.NANOSECONDS);
                if (this.lease == null) {
                    this.ipcSem.setNodeData(null);
                    return false;
                }
                this.leaseVersion = leaseVersion;
                assert (Arrays.equals(this.lease.getData(), leaseVersion));
                return true;
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (Throwable e) {
                throw new UnavailableStateException(e);
            }
        });
    }

    public void unlock() throws UnavailableStateException {
        this.run(() -> {
            this.checkUnavailable();
            Lease lease = this.lease;
            if (lease != null) {
                this.lease = null;
                this.leaseVersion = null;
                try {
                    this.ipcSem.returnLease(lease);
                }
                catch (Throwable e) {
                    throw new UnavailableStateException(e);
                }
            }
            return null;
        });
    }

    public void addListener(DistributedLock.UnavailableLockListener listener) {
        this.run(() -> {
            this.listeners.add(listener);
            this.fireUnavailableListener(() -> ((DistributedLock.UnavailableLockListener)listener).onUnavailableLockEvent());
            return null;
        });
    }

    public void removeListener(DistributedLock.UnavailableLockListener listener) {
        this.run(() -> {
            this.listeners.remove(listener);
            return null;
        });
    }

    @Override
    protected void handleClosed() {
        super.handleClosed();
        this.listeners.clear();
        Lease lease = this.lease;
        if (lease == null) {
            return;
        }
        this.lease = null;
        if (this.isUnavailable()) {
            return;
        }
        try {
            this.ipcSem.returnLease(lease);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

