/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect;

import io.netty.channel.ChannelPipeline;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnection;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.BrokerConnection;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManager;
import org.apache.activemq.artemis.protocol.amqp.broker.ProtonProtocolManagerFactory;
import org.apache.activemq.artemis.protocol.amqp.connect.AMQPBrokerConnection;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.ClientConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.SessionContext;
import org.apache.activemq.artemis.spi.core.remoting.TopologyResponseHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPBrokerConnectionManager
implements ActiveMQComponent,
ClientConnectionLifeCycleListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ProtonProtocolManagerFactory protonProtocolManagerFactory;
    private final ActiveMQServer server;
    private volatile boolean started = false;
    List<AMQPBrokerConnectConfiguration> amqpConnectionsConfig;
    List<AMQPBrokerConnection> amqpBrokerConnectionList;
    ProtonProtocolManager protonProtocolManager;

    public AMQPBrokerConnectionManager(ProtonProtocolManagerFactory factory, List<AMQPBrokerConnectConfiguration> amqpConnectionsConfig, ActiveMQServer server) {
        this.amqpConnectionsConfig = amqpConnectionsConfig;
        this.server = server;
        this.protonProtocolManagerFactory = factory;
    }

    public void start() throws Exception {
        if (!this.started) {
            this.started = true;
        }
        this.amqpBrokerConnectionList = new ArrayList<AMQPBrokerConnection>();
        for (AMQPBrokerConnectConfiguration config : this.amqpConnectionsConfig) {
            NettyConnectorFactory factory = new NettyConnectorFactory().setServerConnector(true);
            this.protonProtocolManager = (ProtonProtocolManager)this.protonProtocolManagerFactory.createProtocolManager(this.server, ((TransportConfiguration)config.getTransportConfigurations().get(0)).getExtraParams(), null, null);
            NettyConnector bridgesConnector = (NettyConnector)factory.createConnector(((TransportConfiguration)config.getTransportConfigurations().get(0)).getParams(), null, (ClientConnectionLifeCycleListener)this, (Executor)this.server.getExecutorFactory().getExecutor(), this.server.getThreadPool(), this.server.getScheduledPool(), (ClientProtocolManager)new ClientProtocolManagerWithAMQP(this.protonProtocolManager));
            bridgesConnector.start();
            logger.debug("Connecting {}", (Object)config);
            AMQPBrokerConnection amqpBrokerConnection = new AMQPBrokerConnection(this, config, this.protonProtocolManager, this.server, bridgesConnector);
            this.amqpBrokerConnectionList.add(amqpBrokerConnection);
            this.server.registerBrokerConnection((BrokerConnection)amqpBrokerConnection);
            if (!config.isAutostart()) continue;
            amqpBrokerConnection.start();
        }
    }

    public void connected(NettyConnection nettyConnection, AMQPBrokerConnection bridgeConnection) {
    }

    public void stop() throws Exception {
        if (this.started) {
            this.started = false;
            for (AMQPBrokerConnection connection : this.amqpBrokerConnectionList) {
                connection.stop();
            }
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
    }

    public void connectionDestroyed(Object connectionID) {
        for (AMQPBrokerConnection connection : this.amqpBrokerConnectionList) {
            if (connection.getConnection() == null || !connectionID.equals(connection.getConnection().getID())) continue;
            connection.connectionDestroyed(connectionID);
        }
    }

    public void connectionException(Object connectionID, ActiveMQException me) {
        for (AMQPBrokerConnection connection : this.amqpBrokerConnectionList) {
            if (connection.getConnection() == null || !connectionID.equals(connection.getConnection().getID())) continue;
            connection.connectionException(connectionID, me);
        }
    }

    public void connectionReadyForWrites(Object connectionID, boolean ready) {
        for (AMQPBrokerConnection connection : this.amqpBrokerConnectionList) {
            if (!connection.getConnection().getID().equals(connectionID)) continue;
            connection.connectionReadyForWrites(connectionID, ready);
        }
    }

    public static class ClientProtocolManagerWithAMQP
    implements ClientProtocolManager {
        public final ProtonProtocolManager protonPM;

        public ClientProtocolManagerWithAMQP(ProtonProtocolManager protonPM) {
            this.protonPM = protonPM;
        }

        public ProtonProtocolManager getProtonPM() {
            return this.protonPM;
        }

        public ClientProtocolManager setExecutor(Executor executor) {
            return null;
        }

        public RemotingConnection connect(Connection transportConnection, long callTimeout, long callFailoverTimeout, List<Interceptor> incomingInterceptors, List<Interceptor> outgoingInterceptors, TopologyResponseHandler topologyResponseHandler) {
            return null;
        }

        public RemotingConnection getCurrentConnection() {
            return null;
        }

        public Lock lockSessionCreation() {
            return null;
        }

        public boolean waitOnLatch(long milliseconds) throws InterruptedException {
            return false;
        }

        public void stop() {
        }

        public boolean isAlive() {
            return false;
        }

        public void addChannelHandlers(ChannelPipeline pipeline) {
        }

        public void sendSubscribeTopology(boolean isServer) {
        }

        public void ping(long connectionTTL) {
        }

        public SessionContext createSessionContext(String name, String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, int minLargeMessageSize, int confirmationWindowSize, String clientID) throws ActiveMQException {
            return null;
        }

        public boolean cleanupBeforeFailover(ActiveMQException cause) {
            return false;
        }

        public boolean checkForFailover(String liveNodeID) throws ActiveMQException {
            return false;
        }

        public void setSessionFactory(ClientSessionFactory factory) {
        }

        public ClientSessionFactory getSessionFactory() {
            return null;
        }

        public String getName() {
            return null;
        }
    }
}

