/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import com.github.rvesse.airline.annotations.Option;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.cli.commands.Action;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.InvalidOptionsError;
import org.apache.activemq.artemis.cli.commands.OptionsUtil;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.FileDeploymentManager;
import org.apache.activemq.artemis.core.config.impl.FileConfiguration;
import org.apache.activemq.artemis.core.deployers.Deployable;
import org.apache.activemq.artemis.utils.ConfigurationHelper;

public abstract class ActionAbstract
implements Action {
    public static final String DEFAULT_BROKER_URL = "tcp://localhost:61616";
    public static final String DEFAULT_BROKER_ACCEPTOR = "artemis";
    @Option(name={"--verbose"}, description="Print additional information.")
    public boolean verbose;
    String brokerConfigurationFileName = "broker.xml";
    private String brokerInstance;
    private String brokerHome;
    private String brokerEtc;
    private URI brokerInstanceURI;
    private ActionContext actionContext;

    protected ActionContext getActionContext() {
        if (this.actionContext == null) {
            this.actionContext = ActionContext.system();
        }
        return this.actionContext;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setHomeValues(File brokerHome, File brokerInstance, File etcFolder) {
        if (brokerHome != null) {
            this.brokerHome = brokerHome.getAbsolutePath();
        }
        if (brokerInstance != null) {
            this.brokerInstance = brokerInstance.getAbsolutePath();
        }
        if (etcFolder != null) {
            this.brokerEtc = etcFolder.getAbsolutePath();
        }
    }

    @Override
    public String getBrokerInstance() {
        if (this.brokerInstance == null) {
            this.brokerInstance = System.getProperty("artemis.instance");
            if (this.brokerInstance != null) {
                this.brokerInstance = this.brokerInstance.replace("\\", "/");
                System.setProperty("artemis.instance", this.brokerInstance);
            }
        }
        return this.brokerInstance;
    }

    public String getBrokerURLInstance(String name) {
        String uri = null;
        if (this.getBrokerInstance() != null) {
            try {
                Configuration brokerConfiguration = this.getBrokerConfiguration();
                if (name == null) {
                    name = DEFAULT_BROKER_ACCEPTOR;
                }
                if ((uri = this.findTransportURI(name, brokerConfiguration.getAcceptorConfigurations())) == null) {
                    uri = this.findTransportURI(name, brokerConfiguration.getConnectorConfigurations().values());
                }
                return uri;
            }
            catch (Exception e) {
                this.getActionContext().out.print("Can not get the broker url instance: " + e.getMessage());
                e.printStackTrace(this.getActionContext().out);
            }
        }
        if (uri == null) {
            uri = DEFAULT_BROKER_URL;
        }
        return uri;
    }

    private String findTransportURI(String name, Collection<TransportConfiguration> configurationis) throws Exception {
        for (TransportConfiguration acceptorConfiguration : configurationis) {
            if (!acceptorConfiguration.getName().equals(name)) continue;
            Map acceptorParams = acceptorConfiguration.getParams();
            String scheme = ConfigurationHelper.getStringProperty((String)"scheme", (String)"tcp", (Map)acceptorParams);
            String host = ConfigurationHelper.getStringProperty((String)"host", (String)"localhost", (Map)acceptorParams);
            int port = ConfigurationHelper.getIntProperty((String)"port", (int)61616, (Map)acceptorParams);
            if (InetAddress.getByName(host).isAnyLocalAddress()) {
                host = "localhost";
            }
            return new URI(scheme, null, host, port, null, null, null).toString();
        }
        return null;
    }

    protected Configuration getBrokerConfiguration() throws Exception {
        FileConfiguration fileConfiguration = new FileConfiguration();
        String brokerConfiguration = new File(new File(this.getBrokerEtc()), this.brokerConfigurationFileName).toURI().toASCIIString();
        FileDeploymentManager fileDeploymentManager = new FileDeploymentManager(brokerConfiguration);
        fileDeploymentManager.addDeployable((Deployable)fileConfiguration);
        fileDeploymentManager.readConfiguration();
        return fileConfiguration;
    }

    public String getBrokerEtc() {
        if (this.brokerEtc == null) {
            this.brokerEtc = System.getProperty("artemis.instance.etc");
            this.brokerEtc = this.brokerEtc != null ? this.brokerEtc.replace("\\", "/") : this.getBrokerInstance() + "/etc";
        }
        return this.brokerEtc;
    }

    public URI getBrokerURIInstance() {
        if (this.brokerInstanceURI == null) {
            String instanceProperty = this.getBrokerInstance();
            File artemisInstance = null;
            if (artemisInstance == null && instanceProperty != null) {
                artemisInstance = new File(instanceProperty);
            }
            if (artemisInstance != null) {
                this.brokerInstanceURI = artemisInstance.toURI();
            }
        }
        return this.brokerInstanceURI;
    }

    @Override
    public String getBrokerHome() {
        if (this.brokerHome == null) {
            this.brokerHome = System.getProperty("artemis.home");
            if (this.brokerHome != null) {
                this.brokerHome = this.brokerHome.replace("\\", "/");
                System.setProperty("artemis.home", this.brokerHome);
            }
            if (this.brokerHome == null) {
                this.brokerHome = ".";
            }
        }
        return this.brokerHome;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        this.actionContext = context;
        ActionContext.setSystem(context);
        return null;
    }

    @Override
    public void checkOptions(String[] options) throws InvalidOptionsError {
        OptionsUtil.checkCommandOptions(this.getClass(), options);
    }
}

