/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages;

import com.github.rvesse.airline.annotations.Option;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.artemis.cli.commands.messages.ConnectionAbstract;
import org.apache.activemq.artemis.cli.factory.serialize.MessageSerializer;
import org.apache.activemq.artemis.cli.factory.serialize.XMLMessageSerializer;

public class DestAbstract
extends ConnectionAbstract {
    @Option(name={"--destination"}, description="Destination to be used. It can be prefixed with queue:// or topic:// and can be an FQQN in the form of <address>::<queue>. Default: queue://TEST.")
    String destination = "queue://TEST";
    @Option(name={"--message-count"}, description="Number of messages to act on. Default: 1000.")
    int messageCount = 1000;
    @Option(name={"--sleep"}, description="Time wait between each message.")
    int sleep = 0;
    @Option(name={"--txt-size"}, description="Transaction batch size.")
    int txBatchSize;
    @Option(name={"--threads"}, description="Number of threads to use. Default: 1.")
    int threads = 1;
    @Option(name={"--serializer"}, description="The class name of the custom serializer implementation to use intead of the default.")
    String serializer;

    protected MessageSerializer getMessageSerializer() {
        if (this.serializer != null) {
            try {
                return (MessageSerializer)Class.forName(this.serializer).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                System.err.println("Error: unable to instantiate serializer class: " + this.serializer);
                System.err.println("Defaulting to: " + XMLMessageSerializer.class.getName());
            }
        }
        if (!this.protocol.equalsIgnoreCase("CORE")) {
            System.err.println("Default Serializer does not support: " + this.protocol + " protocol");
            return null;
        }
        return new XMLMessageSerializer();
    }

    protected Destination getDestination(Session session) throws JMSException {
        return DestAbstract.getDestination(session, this.destination);
    }

    public static Destination getDestination(Session session, String destination) throws JMSException {
        if (destination.startsWith("topic://")) {
            return session.createTopic(DestAbstract.stripPrefix(destination));
        }
        return session.createQueue(DestAbstract.stripPrefix(destination));
    }

    public static String stripPrefix(String destination) {
        int index = destination.indexOf("://");
        if (index != -1) {
            return destination.substring(index + 3);
        }
        return destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public DestAbstract setDestination(String destination) {
        this.destination = destination;
        return this;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public DestAbstract setMessageCount(int messageCount) {
        this.messageCount = messageCount;
        return this;
    }

    public int getSleep() {
        return this.sleep;
    }

    public DestAbstract setSleep(int sleep) {
        this.sleep = sleep;
        return this;
    }

    public int getTxBatchSize() {
        return this.txBatchSize;
    }

    public DestAbstract setTxBatchSize(int txBatchSize) {
        this.txBatchSize = txBatchSize;
        return this;
    }

    public int getThreads() {
        return this.threads;
    }

    public DestAbstract setThreads(int threads) {
        this.threads = threads;
        return this;
    }

    public String getSerializer() {
        return this.serializer;
    }

    public DestAbstract setSerializer(String serializer) {
        this.serializer = serializer;
        return this;
    }
}

