/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools;

import com.github.rvesse.airline.annotations.Option;
import java.io.File;
import org.apache.activemq.artemis.cli.commands.Configurable;

public abstract class DataAbstract
extends Configurable {
    @Option(name={"--bindings"}, description="The folder used for bindings. Default: read from broker.xml.")
    public String binding;
    @Option(name={"--journal"}, description="The folder used for normal messages. Default: read from broker.xml.")
    public String journal;
    @Option(name={"--paging"}, description="The folder used for paged messages. Default: read from broker.xml.")
    public String paging;
    @Option(name={"--large-messages"}, description="The folder used for large-messages. Default: read from broker.xml.")
    public String largeMessges;

    public String getLargeMessages() throws Exception {
        if (this.largeMessges == null) {
            this.largeMessges = this.getFileConfiguration().getLargeMessagesLocation().getAbsolutePath();
        }
        this.checkIfDirectoryExists(this.largeMessges);
        return this.largeMessges;
    }

    public String getBinding() throws Exception {
        if (this.binding == null) {
            this.binding = this.getFileConfiguration().getBindingsLocation().getAbsolutePath();
        }
        this.checkIfDirectoryExists(this.binding);
        return this.binding;
    }

    public String getJournal() throws Exception {
        if (this.journal == null) {
            this.journal = this.getFileConfiguration().getJournalLocation().getAbsolutePath();
        }
        this.checkIfDirectoryExists(this.journal);
        return this.journal;
    }

    public String getPaging() throws Exception {
        if (this.paging == null) {
            this.paging = this.getFileConfiguration().getPagingLocation().getAbsolutePath();
        }
        this.checkIfDirectoryExists(this.paging);
        return this.paging;
    }

    private void checkIfDirectoryExists(String directory) {
        File f = new File(directory);
        if (!f.exists()) {
            throw new IllegalStateException("Could not find folder: " + directory + ", please pass --bindings, --journal and --paging as arguments");
        }
    }
}

