/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.errors;

import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.utils.AirlineUtils;
import java.util.Set;

public class ParseArgumentsIllegalValueException
extends ParseRestrictionViolatedException {
    private static final long serialVersionUID = 810812151673279427L;
    private final String optionTitle;
    private final Object illegalValue;
    private final Set<Object> allowedValues;

    public ParseArgumentsIllegalValueException(String optionTitle, Object value, Set<Object> allowedValues) {
        super("Value for argument '%s' was given as '%s' which is not in the list of allowed values: %s", optionTitle, value, allowedValues);
        this.optionTitle = optionTitle;
        this.illegalValue = value;
        this.allowedValues = AirlineUtils.unmodifiableSetCopy(allowedValues);
    }

    public String getOptionTitle() {
        return this.optionTitle;
    }

    public Object getIllegalValue() {
        return this.illegalValue;
    }

    public Set<Object> getAllowedValues() {
        return this.allowedValues;
    }
}

