/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.critical;

import org.apache.activemq.artemis.utils.critical.CriticalAnalyzer;
import org.apache.activemq.artemis.utils.critical.CriticalComponent;
import org.apache.activemq.artemis.utils.critical.CriticalMeasure;
import org.apache.activemq.artemis.utils.critical.EmptyCriticalAnalyzer;

public class CriticalComponentImpl
implements CriticalComponent {
    private final CriticalMeasure[] measures;
    private final CriticalAnalyzer analyzer;

    public CriticalAnalyzer getCriticalAnalyzer() {
        return this.analyzer;
    }

    public CriticalComponentImpl(CriticalAnalyzer analyzer, int numberOfPaths) {
        if (analyzer == null) {
            analyzer = EmptyCriticalAnalyzer.getInstance();
        }
        this.analyzer = analyzer;
        if (analyzer.isMeasuring()) {
            this.measures = new CriticalMeasure[numberOfPaths];
            for (int i = 0; i < numberOfPaths; ++i) {
                this.measures[i] = new CriticalMeasure();
            }
        } else {
            this.measures = null;
        }
    }

    @Override
    public void enterCritical(int path) {
        if (this.analyzer.isMeasuring()) {
            this.measures[path].enterCritical();
        }
    }

    @Override
    public void leaveCritical(int path) {
        if (this.analyzer.isMeasuring()) {
            this.measures[path].leaveCritical();
        }
    }

    @Override
    public boolean isExpired(long timeout) {
        for (int i = 0; i < this.measures.length; ++i) {
            if (!this.measures[i].isExpired(timeout)) continue;
            return true;
        }
        return false;
    }
}

