/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.blocks;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedOperation;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.LogFactory;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class Cache<K, V> {
    private static final Log log = LogFactory.getLog(Cache.class);
    private final ConcurrentMap<K, Value<V>> map = Util.createConcurrentMap();
    private ScheduledThreadPoolExecutor timer = new ScheduledThreadPoolExecutor(1);
    private Future task = null;
    private final AtomicBoolean is_reaping = new AtomicBoolean(false);
    private final Set<ChangeListener> change_listeners = new LinkedHashSet<ChangeListener>();
    @ManagedAttribute(writable=true)
    private int max_num_entries = 0;

    public int getMaxNumberOfEntries() {
        return this.max_num_entries;
    }

    public void setMaxNumberOfEntries(int max_num_entries) {
        this.max_num_entries = max_num_entries;
    }

    public void addChangeListener(ChangeListener l) {
        this.change_listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.change_listeners.remove(l);
    }

    @ManagedAttribute
    public int getSize() {
        return this.map.size();
    }

    @ManagedAttribute
    public boolean isReapingEnabled() {
        return this.task != null && !this.task.isCancelled();
    }

    @ManagedOperation
    public void enableReaping(long interval) {
        if (this.task != null) {
            this.task.cancel(false);
        }
        this.task = this.timer.scheduleWithFixedDelay(new Reaper(), 0L, interval, TimeUnit.MILLISECONDS);
    }

    @ManagedOperation
    public void disableReaping() {
        if (this.task != null) {
            this.task.cancel(false);
            this.task = null;
        }
    }

    @ManagedOperation
    public void start() {
        if (this.timer == null) {
            this.timer = new ScheduledThreadPoolExecutor(1);
        }
    }

    @ManagedOperation
    public void stop() {
        if (this.timer != null) {
            this.timer.shutdown();
        }
        this.timer = null;
    }

    @ManagedOperation
    public V put(K key, V val, long caching_time) {
        boolean rc;
        if (log.isTraceEnabled()) {
            log.trace("put(" + String.valueOf(key) + ", " + String.valueOf(val) + ", " + caching_time + ")");
        }
        Value<V> value = new Value<V>(val, caching_time);
        Value<V> retval = this.map.put(key, value);
        if (this.max_num_entries > 0 && this.map.size() > this.max_num_entries && (rc = this.is_reaping.compareAndSet(false, true))) {
            if (log.isTraceEnabled()) {
                log.trace("reaping: max_num_entries=" + this.max_num_entries + ", size=" + this.map.size());
            }
            this.timer.execute(() -> {
                if (this.max_num_entries > 0) {
                    try {
                        if (this.map.size() > this.max_num_entries) {
                            this.evict();
                        }
                        if (this.map.size() > this.max_num_entries) {
                            int diff = this.map.size() - this.max_num_entries;
                            TreeMap tmp = new TreeMap();
                            for (Map.Entry entry : this.map.entrySet()) {
                                tmp.put(((Value)entry.getValue()).insertion_time, entry.getKey());
                            }
                            Collection vals = tmp.values();
                            for (Object k : vals) {
                                if (diff-- <= 0) break;
                                Value v = (Value)this.map.remove(k);
                                if (!log.isTraceEnabled()) continue;
                                log.trace("evicting " + String.valueOf(k) + ": " + String.valueOf(v.value));
                            }
                        }
                        if (log.isTraceEnabled()) {
                            log.trace("done reaping (size=" + this.map.size() + ")");
                        }
                    }
                    finally {
                        this.is_reaping.set(false);
                    }
                }
            });
        }
        return this.getValue(retval);
    }

    @ManagedOperation
    public V get(K key) {
        Value val;
        if (log.isTraceEnabled()) {
            log.trace("get(" + String.valueOf(key) + ")");
        }
        if (this.isExpired(val = (Value)this.map.get(key))) {
            this.map.remove(key);
            return null;
        }
        return this.getValue(val);
    }

    public ConcurrentMap<K, Value<V>> getInternalMap() {
        return this.map;
    }

    public Value<V> getEntry(K key) {
        if (log.isTraceEnabled()) {
            log.trace("getEntry(" + String.valueOf(key) + ")");
        }
        return (Value)this.map.get(key);
    }

    public V remove(K key) {
        if (log.isTraceEnabled()) {
            log.trace("remove(" + String.valueOf(key) + ")");
        }
        return this.getValue((Value)this.map.remove(key));
    }

    public Set<Map.Entry<K, Value<V>>> entrySet() {
        return this.map.entrySet();
    }

    @ManagedOperation
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.map.entrySet()) {
            Value val = (Value)entry.getValue();
            sb.append(entry.getKey()).append(": ").append(((Value)entry.getValue()).getValue());
            sb.append(" (expiration_time: ");
            long expiration_time = val.getTimeout();
            if (expiration_time <= 0L) {
                sb.append(expiration_time);
            } else {
                sb.append(Util.utcEpoch(expiration_time));
            }
            sb.append(")\n");
        }
        return sb.toString();
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.map.entrySet()) {
            sb.append(entry.getKey()).append(": ");
            V val = this.getValue((Value)entry.getValue());
            if (val != null) {
                if (val instanceof byte[]) {
                    sb.append(" (" + ((byte[])val).length).append(" bytes)");
                } else {
                    sb.append(val);
                }
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private void evict() {
        boolean evicted = false;
        Iterator it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Value val = (Value)entry.getValue();
            evicted = this.isExpired(val);
            if (!evicted) continue;
            if (log.isTraceEnabled()) {
                log.trace("evicting " + String.valueOf(entry.getKey()) + ": " + String.valueOf(this.getValue(val)));
            }
            it.remove();
        }
        if (evicted) {
            this.notifyChangeListeners();
        }
    }

    private void notifyChangeListeners() {
        for (ChangeListener l : this.change_listeners) {
            try {
                l.changed();
            }
            catch (Throwable t) {
                log.error(Util.getMessage("FailedNotifyingChangeListener"), t);
            }
        }
    }

    private V getValue(Value<V> val) {
        return val == null ? null : (V)val.getValue();
    }

    private boolean isExpired(Value<V> val) {
        return val != null && (val.timeout == -1L || val.timeout > 0L && System.currentTimeMillis() > val.insertion_time + val.timeout);
    }

    private class Reaper
    implements Runnable {
        private Reaper() {
        }

        @Override
        public void run() {
            Cache.this.evict();
        }
    }

    public static class Value<V>
    implements Externalizable {
        private V value;
        private long insertion_time = System.currentTimeMillis();
        private transient long timeout;
        private static final long serialVersionUID = -3445944261826378608L;

        public Value(V value, long timeout) {
            this.value = value;
            this.timeout = timeout;
        }

        public Value() {
        }

        public V getValue() {
            return this.value;
        }

        public long getInsertionTime() {
            return this.insertion_time;
        }

        public long getTimeout() {
            return this.timeout;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.timeout);
            out.writeObject(this.value);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.insertion_time = System.currentTimeMillis();
            this.timeout = in.readLong();
            this.value = in.readObject();
        }
    }

    public static interface ChangeListener {
        public void changed();
    }
}

