/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class ExpiryCache<K> {
    protected long timeout;
    protected final ConcurrentMap<K, Long> map = new ConcurrentHashMap<K, Long>();

    public ExpiryCache(long timeout) {
        this.setTimeout(timeout);
    }

    public long getTimeout() {
        return TimeUnit.MILLISECONDS.convert(this.timeout, TimeUnit.NANOSECONDS);
    }

    public void setTimeout(long timeout) {
        this.timeout = TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS);
    }

    public boolean addIfAbsentOrExpired(K key) {
        Long val = (Long)this.map.get(key);
        if (val == null) {
            return this.map.putIfAbsent(key, System.nanoTime()) == null;
        }
        long current_time = System.nanoTime();
        return this.hasExpired(val, current_time) && this.map.replace(key, val, current_time);
    }

    public boolean contains(K key) {
        return key != null && this.map.containsKey(key);
    }

    public boolean hasExpired(K key) {
        Long val = (Long)this.map.get(key);
        return val != null && this.hasExpired(val, System.nanoTime());
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    public void removeAll(Collection<K> keys) {
        this.map.keySet().removeAll(keys);
    }

    public int removeExpiredElements() {
        int removed = 0;
        long current_time = System.nanoTime();
        for (Map.Entry entry : this.map.entrySet()) {
            Long val = (Long)entry.getValue();
            if (val != null && !this.hasExpired(val, current_time)) continue;
            this.map.remove(entry.getKey());
            ++removed;
        }
        return removed;
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        long current_time = System.nanoTime();
        for (Map.Entry entry : this.map.entrySet()) {
            sb.append(entry.getKey()).append(": (age: ");
            long val = (Long)entry.getValue();
            long age = TimeUnit.MILLISECONDS.convert(current_time - val, TimeUnit.NANOSECONDS);
            if (age < 1000L) {
                sb.append(age).append(" ms)");
            } else {
                sb.append(TimeUnit.SECONDS.convert(age, TimeUnit.MILLISECONDS)).append(" secs");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    protected boolean hasExpired(long val, long current_time) {
        return current_time - val > this.timeout;
    }
}

