/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.remoting.impl.ssl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.activemq.artemis.core.remoting.impl.ssl.DefaultOpenSSLContextFactory;
import org.apache.activemq.artemis.shaded.io.netty.handler.ssl.SslContext;
import org.apache.activemq.artemis.spi.core.remoting.ssl.SSLContextConfig;

public class CachingOpenSSLContextFactory
extends DefaultOpenSSLContextFactory {
    private final ConcurrentMap<SSLContextConfig, SslContext> clientSslContextCache = new ConcurrentHashMap<SSLContextConfig, SslContext>(2);
    private final ConcurrentMap<SSLContextConfig, SslContext> serversSslContextCache = new ConcurrentHashMap<SSLContextConfig, SslContext>(2);

    @Override
    public void clearSslContexts() {
        this.clientSslContextCache.clear();
        this.serversSslContextCache.clear();
    }

    @Override
    public SslContext getClientSslContext(SSLContextConfig config, Map<String, Object> additionalOpts) throws Exception {
        return this.clientSslContextCache.computeIfAbsent(config, this::getClientSslContext);
    }

    private SslContext getClientSslContext(SSLContextConfig config) {
        try {
            return super.getClientSslContext(config, null);
        }
        catch (Exception ex) {
            throw new RuntimeException("An unexpected exception occured while creating Client OpenSSL Context with " + config, ex);
        }
    }

    @Override
    public SslContext getServerSslContext(SSLContextConfig config, Map<String, Object> additionalOpts) throws Exception {
        return this.clientSslContextCache.computeIfAbsent(config, this::getServerSslContext);
    }

    private SslContext getServerSslContext(SSLContextConfig config) {
        try {
            return super.getServerSslContext(config, null);
        }
        catch (Exception ex) {
            throw new RuntimeException("An unexpected exception occured while creating Server OpenSSL Context " + config, ex);
        }
    }

    @Override
    public int getPriority() {
        return 10;
    }
}

