/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.util.Objects;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.logging.Log;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.Bundler;
import org.apache.activemq.artemis.shaded.org.jgroups.protocols.TP;
import org.apache.activemq.artemis.shaded.org.jgroups.util.ByteArrayDataOutputStream;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class NoBundler
implements Bundler {
    protected TP transport;
    protected Log log;

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int getMaxSize() {
        return 64000;
    }

    @Override
    public void init(TP transport) {
        this.transport = Objects.requireNonNull(transport);
        this.log = transport.getLog();
    }

    @Override
    public int getQueueSize() {
        return -1;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void send(Message msg) throws Exception {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(msg.size() + 10);
        this.sendSingleMessage(msg, out);
    }

    protected void sendSingleMessage(Message msg, ByteArrayDataOutputStream output) throws Exception {
        Address dest = msg.getDest();
        output.position(0);
        Util.writeMessage(msg, output, dest == null);
        this.transport.doSend(output.buffer(), 0, output.position(), dest);
        if (this.transport.statsEnabled()) {
            this.transport.getMessageStats().incrNumSingleMsgsSent(1);
        }
    }
}

