/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.Property;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.AverageMinMax;
import org.apache.activemq.artemis.shaded.org.jgroups.util.MessageBatch;

@MBean(description="Measures message delivery times")
public class TIME
extends Protocol {
    @ManagedAttribute(description="Average delivery time (in microseconds) for single messages")
    protected final AverageMinMax up_delivery_msgs = (AverageMinMax)new AverageMinMax().unit(TimeUnit.MICROSECONDS);
    @ManagedAttribute(description="Average delivery time (in microseconds) for message batches")
    protected final AverageMinMax up_delivery_batches = (AverageMinMax)new AverageMinMax().unit(TimeUnit.MICROSECONDS);
    @ManagedAttribute(description="Average down delivery time (in microseconds)")
    protected final AverageMinMax down_delivery = (AverageMinMax)new AverageMinMax().unit(TimeUnit.MICROSECONDS);
    @Property(description="Enables or disables measuring times of messages sent down")
    protected boolean down_msgs;
    @Property(description="Enables or disables measuring times of message batches received from below")
    protected boolean up_batches = true;
    @Property(description="Enables or disables measuring times of messages received from below. Attribute up_batches has to be true, or else up_msgs will be ignored")
    protected boolean up_msgs;

    @Override
    public void resetStats() {
        this.down_delivery.clear();
        this.up_delivery_msgs.clear();
        this.up_delivery_batches.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Message msg) {
        if (!this.down_msgs) {
            return this.down_prot.down(msg);
        }
        long start = System.nanoTime();
        try {
            Object object = this.down_prot.down(msg);
            return object;
        }
        finally {
            long time = (System.nanoTime() - start) / 1000L;
            TIME.add(this.down_delivery, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Message msg) {
        if (!this.up_msgs) {
            return this.up_prot.up(msg);
        }
        long start = System.nanoTime();
        try {
            Object object = this.up_prot.up(msg);
            return object;
        }
        finally {
            long time = (System.nanoTime() - start) / 1000L;
            TIME.add(this.up_delivery_msgs, time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void up(MessageBatch batch) {
        if (!this.up_batches) {
            this.up_prot.up(batch);
            return;
        }
        long start = System.nanoTime();
        try {
            this.up_prot.up(batch);
        }
        finally {
            long time = (System.nanoTime() - start) / 1000L;
            TIME.add(this.up_delivery_batches, time);
        }
    }

    protected static double avgTimePerMessageIncludingDelay(int num, long time) {
        double avg_per_msg = (double)time / (double)num;
        double total = 0.0;
        for (int i = 0; i < num; ++i) {
            total += avg_per_msg * (double)i + avg_per_msg;
        }
        return total / (double)num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void add(AverageMinMax avg, long num) {
        if (num > 0L) {
            AverageMinMax averageMinMax = avg;
            synchronized (averageMinMax) {
                avg.add(num);
            }
        }
    }
}

