/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.activemq.artemis.shaded.org.jgroups.Address;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Streamable;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class MergeId
implements Streamable {
    private Address initiator;
    private int id;
    private static int LAST_ID = 1;

    public MergeId() {
    }

    private MergeId(Address initiator, int id) {
        this.initiator = initiator;
        this.id = id;
    }

    public static synchronized MergeId create(Address addr) {
        if (addr == null) {
            throw new IllegalArgumentException("initiator has to be non null");
        }
        int id = LAST_ID++;
        return new MergeId(addr, id);
    }

    public boolean equals(Object obj) {
        return obj instanceof MergeId && this.initiator.equals(((MergeId)obj).initiator) && this.id == ((MergeId)obj).id;
    }

    public int hashCode() {
        return this.initiator.hashCode() + this.id;
    }

    public int size() {
        return Util.size(this.initiator) + 4;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        Util.writeAddress(this.initiator, out);
        out.writeInt(this.id);
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        this.initiator = Util.readAddress(in);
        this.id = in.readInt();
    }

    public String toString() {
        return String.valueOf(this.initiator) + "::" + this.id;
    }
}

