/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers.derby;

import org.apache.activemq.artemis.jdbc.store.sql.GenericSQLProvider;
import org.apache.activemq.artemis.jdbc.store.sql.SQLProvider;

public class DerbySQLProvider
extends GenericSQLProvider {
    private static final int MAX_BLOB_SIZE = Integer.MAX_VALUE;
    private final String createFileTableSQL;
    private final String appendToFileSQL;

    private DerbySQLProvider(String tableName) {
        super(tableName.toUpperCase());
        this.createFileTableSQL = "CREATE TABLE " + tableName + "(ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1)," + "FILENAME VARCHAR(255), EXTENSION VARCHAR(10), DATA BLOB, PRIMARY KEY(ID))";
        this.appendToFileSQL = "UPDATE " + tableName + " SET DATA = DATA || ? WHERE ID=?";
    }

    @Override
    public int getMaxBlobSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getCreateFileTableSQL() {
        return this.createFileTableSQL;
    }

    @Override
    public String getAppendToLargeObjectSQL() {
        return this.appendToFileSQL;
    }

    @Override
    public boolean closeConnectionOnShutdown() {
        return false;
    }

    public static class Factory
    implements SQLProvider.Factory {
        @Override
        public SQLProvider create(String tableName) {
            return new DerbySQLProvider(tableName);
        }
    }
}

