/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols;

import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Predicate;
import org.apache.activemq.artemis.shaded.org.jgroups.Message;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.MBean;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedAttribute;
import org.apache.activemq.artemis.shaded.org.jgroups.annotations.ManagedOperation;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.MessageBatch;

@MBean(description="Queues the next N messages that are received and passes them up in reverse order")
public class REVERSE
extends Protocol {
    @ManagedAttribute(description="Number of messages to reverse.", writable=true)
    protected volatile int num_msgs_to_reverse;
    protected Predicate<Message> filter;
    protected final Deque<Message> queue = new ConcurrentLinkedDeque<Message>();

    public int numMessagesToReverse() {
        return this.num_msgs_to_reverse;
    }

    public REVERSE numMessagesToReverse(int n) {
        this.num_msgs_to_reverse = n;
        return this;
    }

    public Predicate<Message> filter() {
        return this.filter;
    }

    public REVERSE filter(Predicate<Message> f) {
        this.filter = f;
        return this;
    }

    @ManagedAttribute(description="Number of queued messages")
    public int queuedMessages() {
        return this.queue.size();
    }

    @Override
    public void stop() {
        this.flush();
        super.stop();
    }

    @Override
    public Object up(Message msg) {
        if (this.num_msgs_to_reverse == 0 || this.filter != null && !this.filter.test(msg)) {
            return this.up_prot.up(msg);
        }
        if (this.queue.add(msg) && this.queue.size() >= this.num_msgs_to_reverse) {
            this.flush();
        }
        return null;
    }

    @Override
    public void up(MessageBatch batch) {
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            if (this.num_msgs_to_reverse == 0 || this.filter != null && !this.filter.test(msg)) continue;
            if (this.queue.add(msg) && this.queue.size() >= this.num_msgs_to_reverse) {
                this.flush();
            }
            it.remove();
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @ManagedOperation(description="Sends all queued messages and disables queueing for subsequent messages")
    public REVERSE flush() {
        Message msg;
        while ((msg = this.queue.pollLast()) != null) {
            this.up_prot.up(msg);
        }
        this.num_msgs_to_reverse = 0;
        return this;
    }
}

