/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.protocols.relay.config;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.shaded.org.jgroups.JChannel;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.XmlConfigurator;
import org.apache.activemq.artemis.shaded.org.jgroups.conf.XmlNode;
import org.apache.activemq.artemis.shaded.org.jgroups.stack.Protocol;
import org.apache.activemq.artemis.shaded.org.jgroups.util.Util;

public class RelayConfig {
    protected static final String RELAY_CONFIG = "RelayConfiguration";
    protected static final String SITES = "sites";
    protected static final String SITE = "site";
    protected static final String BRIDGES = "bridges";
    protected static final String BRIDGE = "bridge";
    protected static final String FORWARDS = "forwards";
    protected static final String FORWARD = "forward";

    private RelayConfig() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static void parse(InputStream input, Map<String, SiteConfig> map) throws Exception {
        XmlNode root = XmlConfigurator.parseXmlDocument(input);
        RelayConfig.parse(root, map);
    }

    public static void parse(XmlNode root, Map<String, SiteConfig> map) throws Exception {
        RelayConfig.match(RELAY_CONFIG, root.getName());
        List<XmlNode> children = root.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (XmlNode node : children) {
            RelayConfig.match(SITES, node.getName());
            RelayConfig.parseSites(map, node);
        }
    }

    protected static void parseSites(Map<String, SiteConfig> map, XmlNode root) throws Exception {
        List<XmlNode> children = root.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (XmlNode node : children) {
            RelayConfig.match(SITE, node.getName());
            Map<String, String> attrs = node.getAttributes();
            if (attrs == null || attrs.isEmpty() || !attrs.containsKey("name")) {
                throw new IllegalStateException(String.format("site must have a name (attrs: %s)", attrs));
            }
            String site_name = attrs.get("name");
            if (map.containsKey(site_name)) {
                throw new Exception("Site \"" + site_name + "\" already defined");
            }
            SiteConfig site_config = new SiteConfig(site_name);
            map.put(site_name, site_config);
            RelayConfig.parseBridgesAndForwards(site_config, node);
        }
    }

    protected static void parseBridgesAndForwards(SiteConfig site_config, XmlNode root) throws Exception {
        List<XmlNode> children = root.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (XmlNode node : children) {
            String node_name = node.getName();
            if (BRIDGES.equals(node_name)) {
                RelayConfig.parseBridges(site_config, node);
                continue;
            }
            if (FORWARDS.equals(node_name)) {
                RelayConfig.parseForwards(site_config, node);
                continue;
            }
            throw new Exception("expected \"bridges\" or \"forwards\" keywords");
        }
    }

    protected static void parseBridges(SiteConfig site_config, XmlNode root) throws Exception {
        List<XmlNode> children = root.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (XmlNode node : children) {
            String node_name = node.getName();
            RelayConfig.match(BRIDGE, node_name);
            Map<String, String> attrs = node.getAttributes();
            if (attrs == null || attrs.isEmpty()) continue;
            String name = attrs.get("name");
            String config = attrs.get("config");
            PropertiesBridgeConfig bridge_config = new PropertiesBridgeConfig(name, config);
            site_config.addBridge(bridge_config);
        }
    }

    protected static void parseForwards(SiteConfig site_config, XmlNode root) throws Exception {
        List<XmlNode> children = root.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (XmlNode node : children) {
            RelayConfig.match(FORWARD, node.getName());
            Map<String, String> attrs = node.getAttributes();
            if (attrs == null || attrs.isEmpty()) continue;
            String to = attrs.get("to");
            String gateway = attrs.get("gateway");
            ForwardConfig forward_config = new ForwardConfig(to, gateway);
            site_config.addForward(forward_config);
        }
    }

    protected static void match(String expected_name, String name) throws Exception {
        if (!expected_name.equals(name)) {
            throw new Exception("\"" + name + "\" didn't match \"" + expected_name + "\"");
        }
    }

    public static void main(String[] args) throws Exception {
        FileInputStream input = new FileInputStream("/home/bela/relay2.xml");
        HashMap<String, SiteConfig> sites = new HashMap<String, SiteConfig>();
        RelayConfig.parse(input, sites);
        System.out.println("sites:");
        for (Map.Entry entry : sites.entrySet()) {
            System.out.println((String)entry.getKey() + ":\n" + entry.getValue() + "\n");
        }
    }

    public static class ForwardConfig {
        protected final String to;
        protected final String gateway;

        public ForwardConfig(String to, String gateway) {
            this.to = to;
            this.gateway = gateway;
        }

        public String gateway() {
            return this.gateway;
        }

        public String to() {
            return this.to;
        }

        public String toString() {
            return "forward to=" + this.to + " gw=" + this.gateway;
        }
    }

    public static class ProgrammaticBridgeConfig
    extends BridgeConfig {
        protected Protocol[] protocols;

        public ProgrammaticBridgeConfig(String cluster_name, Protocol[] prots) {
            super(cluster_name);
            this.protocols = prots;
        }

        @Override
        public JChannel createChannel() throws Exception {
            return new JChannel(this.protocols);
        }

        @Override
        public String toString() {
            return super.toString() + ", protocols=" + ProgrammaticBridgeConfig.printProtocols(this.protocols);
        }

        protected static String printProtocols(Protocol[] protocols) {
            StringBuilder sb = new StringBuilder("[");
            boolean first = true;
            for (Protocol prot : protocols) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(prot.getName());
            }
            sb.append("]");
            return sb.toString();
        }
    }

    public static class PropertiesBridgeConfig
    extends BridgeConfig {
        protected final String config;

        public PropertiesBridgeConfig(String cluster_name, String config) {
            super(cluster_name);
            this.config = Util.substituteVariable(config);
        }

        @Override
        public JChannel createChannel() throws Exception {
            return new JChannel(this.config);
        }

        @Override
        public String toString() {
            return String.format("config=%s\n%s", this.config, super.toString());
        }
    }

    public static abstract class BridgeConfig {
        protected String cluster_name;

        protected BridgeConfig(String cluster_name) {
            this.cluster_name = cluster_name;
        }

        public String getClusterName() {
            return this.cluster_name;
        }

        public BridgeConfig setClusterName(String s) {
            this.cluster_name = s;
            return this;
        }

        public abstract JChannel createChannel() throws Exception;

        public String toString() {
            return String.format("bridge %s", this.cluster_name);
        }
    }

    public static class SiteConfig {
        protected final String name;
        protected final List<BridgeConfig> bridges = new ArrayList<BridgeConfig>();
        protected final List<ForwardConfig> forwards = new ArrayList<ForwardConfig>();

        public SiteConfig(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<BridgeConfig> getBridges() {
            return this.bridges;
        }

        public List<ForwardConfig> getForwards() {
            return this.forwards;
        }

        public SiteConfig addBridge(BridgeConfig bridge_config) {
            this.bridges.add(bridge_config);
            return this;
        }

        public SiteConfig addForward(ForwardConfig forward_config) {
            this.forwards.add(forward_config);
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("name=" + this.name + "\n");
            if (!this.bridges.isEmpty()) {
                for (BridgeConfig bridge_config : this.bridges) {
                    sb.append(bridge_config).append("\n");
                }
            }
            if (!this.forwards.isEmpty()) {
                for (ForwardConfig forward_config : this.forwards) {
                    sb.append(forward_config).append("\n");
                }
            }
            return sb.toString();
        }
    }
}

