/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.io.mapped;

import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.core.io.IOCriticalErrorListener;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.buffer.TimedBuffer;
import org.apache.activemq.artemis.core.io.mapped.BytesUtils;
import org.apache.activemq.artemis.core.io.mapped.MappedSequentialFile;
import org.apache.activemq.artemis.core.io.mapped.TimedSequentialFile;
import org.apache.activemq.artemis.utils.Env;

public final class MappedSequentialFileFactory
implements SequentialFileFactory {
    private final File directory;
    private int capacity;
    private final IOCriticalErrorListener criticalErrorListener;
    private final TimedBuffer timedBuffer;
    private boolean useDataSync;
    private boolean bufferPooling;
    private final ThreadLocal<ByteBuffer> bytesPool;

    private MappedSequentialFileFactory(File directory, int capacity, boolean buffered, int bufferSize, int bufferTimeout, IOCriticalErrorListener criticalErrorListener) {
        this.directory = directory;
        this.capacity = capacity;
        this.criticalErrorListener = criticalErrorListener;
        this.useDataSync = true;
        this.timedBuffer = buffered && bufferTimeout > 0 && bufferSize > 0 ? new TimedBuffer(bufferSize, bufferTimeout, false) : null;
        this.bufferPooling = true;
        this.bytesPool = new ThreadLocal();
    }

    public MappedSequentialFileFactory capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public int capacity() {
        return this.capacity;
    }

    public static MappedSequentialFileFactory buffered(File directory, int capacity, int bufferSize, int bufferTimeout, IOCriticalErrorListener criticalErrorListener) {
        return new MappedSequentialFileFactory(directory, capacity, true, bufferSize, bufferTimeout, criticalErrorListener);
    }

    public static MappedSequentialFileFactory unbuffered(File directory, int capacity, IOCriticalErrorListener criticalErrorListener) {
        return new MappedSequentialFileFactory(directory, capacity, false, 0, 0, criticalErrorListener);
    }

    @Override
    public SequentialFile createSequentialFile(String fileName) {
        MappedSequentialFile mappedSequentialFile = new MappedSequentialFile(this, this.directory, new File(this.directory, fileName), this.capacity, this.criticalErrorListener);
        if (this.timedBuffer == null) {
            return mappedSequentialFile;
        }
        return new TimedSequentialFile(this, mappedSequentialFile);
    }

    @Override
    public MappedSequentialFileFactory setDatasync(boolean enabled) {
        this.useDataSync = enabled;
        return this;
    }

    @Override
    public boolean isDatasync() {
        return this.useDataSync;
    }

    @Override
    public int getMaxIO() {
        return 1;
    }

    @Override
    public List<String> listFiles(String extension) throws Exception {
        FilenameFilter extensionFilter = (file, name) -> name.endsWith("." + extension);
        String[] fileNames = this.directory.list(extensionFilter);
        if (fileNames == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(fileNames);
    }

    @Override
    public boolean isSupportsCallbacks() {
        return this.timedBuffer != null;
    }

    @Override
    public void onIOError(Exception exception, String message, SequentialFile file) {
        if (this.criticalErrorListener != null) {
            this.criticalErrorListener.onIOException(exception, message, file);
        }
    }

    @Override
    public ByteBuffer allocateDirectBuffer(int size) {
        int requiredCapacity = (int)BytesUtils.align(size, Env.osPageSize());
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(requiredCapacity);
        byteBuffer.limit(size);
        return byteBuffer;
    }

    @Override
    public void releaseDirectBuffer(ByteBuffer buffer) {
        PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
    }

    public MappedSequentialFileFactory enableBufferReuse() {
        this.bufferPooling = true;
        return this;
    }

    public MappedSequentialFileFactory disableBufferReuse() {
        this.bufferPooling = false;
        return this;
    }

    @Override
    public ByteBuffer newBuffer(int size) {
        if (!this.bufferPooling) {
            return this.allocateDirectBuffer(size);
        }
        int requiredCapacity = (int)BytesUtils.align(size, Env.osPageSize());
        ByteBuffer byteBuffer = this.bytesPool.get();
        if (byteBuffer == null || requiredCapacity > byteBuffer.capacity()) {
            byteBuffer = ByteBuffer.allocateDirect(requiredCapacity);
        } else {
            this.bytesPool.set(null);
            PlatformDependent.setMemory((long)PlatformDependent.directBufferAddress((ByteBuffer)byteBuffer), (long)size, (byte)0);
            byteBuffer.clear();
        }
        byteBuffer.limit(size);
        return byteBuffer;
    }

    @Override
    public void releaseBuffer(ByteBuffer buffer) {
        ByteBuffer byteBuffer;
        if (this.bufferPooling && buffer.isDirect() && (byteBuffer = this.bytesPool.get()) != buffer) {
            if (byteBuffer == null || buffer.capacity() > byteBuffer.capacity()) {
                if (byteBuffer != null) {
                    PlatformDependent.freeDirectBuffer((ByteBuffer)byteBuffer);
                }
                this.bytesPool.set(buffer);
            } else {
                PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
            }
        }
    }

    @Override
    public void activateBuffer(SequentialFile file) {
        if (this.timedBuffer != null) {
            file.setTimedBuffer(this.timedBuffer);
        }
    }

    @Override
    public void deactivateBuffer() {
        if (this.timedBuffer != null) {
            this.timedBuffer.flush();
            this.timedBuffer.setObserver(null);
        }
    }

    @Override
    public ByteBuffer wrapBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public int getAlignment() {
        return 1;
    }

    @Override
    @Deprecated
    public MappedSequentialFileFactory setAlignment(int alignment) {
        throw new UnsupportedOperationException("alignment can't be changed!");
    }

    @Override
    public int calculateBlockSize(int bytes) {
        return bytes;
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public void clearBuffer(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            BytesUtils.zerosDirect(buffer);
        } else if (buffer.hasArray()) {
            byte[] array = buffer.array();
            Arrays.fill(array, (byte)0);
        } else {
            int capacity = buffer.capacity();
            for (int i = 0; i < capacity; ++i) {
                buffer.put(i, (byte)0);
            }
        }
        buffer.rewind();
    }

    @Override
    public void start() {
        if (this.timedBuffer != null) {
            this.timedBuffer.start();
        }
    }

    @Override
    public void stop() {
        if (this.timedBuffer != null) {
            this.timedBuffer.stop();
        }
    }

    @Override
    public void createDirs() throws Exception {
        boolean ok = this.directory.mkdirs();
        if (!ok) {
            throw new IOException("Failed to create directory " + this.directory);
        }
    }

    @Override
    public void flush() {
        if (this.timedBuffer != null) {
            this.timedBuffer.flush();
        }
    }
}

