/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.junit;

import java.util.Map;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.junit.AbstractActiveMQClientDelegate;
import org.apache.activemq.artemis.junit.ActiveMQProducerDelegate;
import org.apache.activemq.artemis.junit.ActiveMQProducerOperations;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ActiveMQProducerExtension
implements BeforeAllCallback,
AfterAllCallback,
ActiveMQProducerOperations {
    private ActiveMQProducerDelegate activeMQProducer;

    protected ActiveMQProducerExtension(String url, String username, String password) {
        this.activeMQProducer = new ActiveMQProducerDelegate(url, username, password);
    }

    protected ActiveMQProducerExtension(String url) {
        this.activeMQProducer = new ActiveMQProducerDelegate(url);
    }

    protected ActiveMQProducerExtension(ServerLocator serverLocator, String username, String password) {
        this.activeMQProducer = new ActiveMQProducerDelegate(serverLocator, username, password);
    }

    protected ActiveMQProducerExtension(ServerLocator serverLocator) {
        this.activeMQProducer = new ActiveMQProducerDelegate(serverLocator);
    }

    public ActiveMQProducerExtension(String url, String address, String username, String password) {
        this.activeMQProducer = new ActiveMQProducerDelegate(url, address, username, password);
    }

    public ActiveMQProducerExtension(String url, String address) {
        this.activeMQProducer = new ActiveMQProducerDelegate(url, address);
    }

    public ActiveMQProducerExtension(String url, SimpleString address, String username, String password) {
        this.activeMQProducer = new ActiveMQProducerDelegate(url, address, username, password);
    }

    public ActiveMQProducerExtension(String url, SimpleString address) {
        this.activeMQProducer = new ActiveMQProducerDelegate(url, address);
    }

    public ActiveMQProducerExtension(ServerLocator serverLocator, String address, String username, String password) {
        this.activeMQProducer = new ActiveMQProducerDelegate(serverLocator, address, username, password);
    }

    public ActiveMQProducerExtension(ServerLocator serverLocator, String address) {
        this.activeMQProducer = new ActiveMQProducerDelegate(serverLocator, address);
    }

    public ActiveMQProducerExtension(ServerLocator serverLocator, SimpleString address, String username, String password) {
        this.activeMQProducer = new ActiveMQProducerDelegate(serverLocator, address, username, password);
    }

    public ActiveMQProducerExtension(ServerLocator serverLocator, SimpleString address) {
        this.activeMQProducer = new ActiveMQProducerDelegate(serverLocator, address);
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        this.activeMQProducer.start();
    }

    public void afterAll(ExtensionContext context) throws Exception {
        this.activeMQProducer.stop();
    }

    public boolean isUseDurableMessage() {
        return this.activeMQProducer.isUseDurableMessage();
    }

    public void setUseDurableMessage(boolean useDurableMessage) {
        this.activeMQProducer.setUseDurableMessage(useDurableMessage);
    }

    protected void createClient() {
        this.activeMQProducer.createClient();
    }

    protected void stopClient() {
        this.activeMQProducer.stopClient();
    }

    public ClientMessage createMessage() {
        return this.activeMQProducer.createMessage();
    }

    public ClientMessage createMessage(byte[] body) {
        return this.activeMQProducer.createMessage(body);
    }

    public ClientMessage createMessage(String body) {
        return this.activeMQProducer.createMessage(body);
    }

    public ClientMessage createMessage(Map<String, Object> properties) {
        return this.activeMQProducer.createMessage(properties);
    }

    public ClientMessage createMessage(byte[] body, Map<String, Object> properties) {
        return this.activeMQProducer.createMessage(body, properties);
    }

    public ClientMessage createMessage(String body, Map<String, Object> properties) {
        return this.activeMQProducer.createMessage(body, properties);
    }

    public void sendMessage(ClientMessage message) {
        this.activeMQProducer.sendMessage(message);
    }

    public ClientMessage sendMessage(byte[] body) {
        return this.activeMQProducer.sendMessage(body);
    }

    public ClientMessage sendMessage(String body) {
        return this.activeMQProducer.sendMessage(body);
    }

    public ClientMessage sendMessage(Map<String, Object> properties) {
        return this.activeMQProducer.sendMessage(properties);
    }

    public ClientMessage sendMessage(byte[] body, Map<String, Object> properties) {
        return this.activeMQProducer.sendMessage(body, properties);
    }

    public ClientMessage sendMessage(String body, Map<String, Object> properties) {
        return this.activeMQProducer.sendMessage(body, properties);
    }

    public static void addMessageProperties(ClientMessage message, Map<String, Object> properties) {
        AbstractActiveMQClientDelegate.addMessageProperties((ClientMessage)message, properties);
    }

    public boolean isAutoCreateQueue() {
        return this.activeMQProducer.isAutoCreateQueue();
    }

    public void setAutoCreateQueue(boolean autoCreateQueue) {
        this.activeMQProducer.setAutoCreateQueue(autoCreateQueue);
    }
}

