/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.maven;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.apache.activemq.artemis.maven.ArtemisAbstractPlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="runClient", defaultPhase=LifecyclePhase.VERIFY)
public class ArtemisClientPlugin
extends ArtemisAbstractPlugin {
    @Parameter
    String clientClass;
    @Parameter
    String[] args;
    @Parameter(defaultValue="${noClient}")
    boolean ignore;
    private Properties systemProperties;

    @Override
    protected boolean isIgnore() {
        return this.ignore;
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        try {
            if (this.systemProperties != null && !this.systemProperties.isEmpty()) {
                System.getProperties().putAll((Map<?, ?>)this.systemProperties);
            }
            Class<?> aClass = Class.forName(this.clientClass);
            Method method = aClass.getDeclaredMethod("main", String[].class);
            method.invoke(null, new Object[]{this.args});
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
    }
}

