/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.maven;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.maven.ArtemisAbstractPlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="dependency-scan", defaultPhase=LifecyclePhase.VERIFY)
public class ArtemisDependencyScanPlugin
extends ArtemisAbstractPlugin {
    @Parameter
    String name;
    private PluginDescriptor descriptor;
    @Parameter
    private String[] libListWithDeps;
    @Parameter
    private String[] libList;
    @Parameter
    private String[] extraRepositories;
    @Parameter
    private String variableName;
    @Parameter
    private String pathSeparator = File.pathSeparator;
    @Parameter
    private File targetFolder;
    private MavenProject project;
    @Parameter
    private boolean optional = false;

    @Override
    protected boolean isIgnore() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        int repositories = 0;
        ArrayList<RemoteRepository> listRepo = new ArrayList<RemoteRepository>();
        if (this.extraRepositories != null) {
            for (String strRepo : this.extraRepositories) {
                RemoteRepository repo = new RemoteRepository.Builder("repo" + repositories++, "default", strRepo).build();
                listRepo.add(repo);
                this.remoteRepos.add(repo);
            }
        }
        this.getLog().info((CharSequence)("Local " + this.localRepository));
        this.project = (MavenProject)this.getPluginContext().get("project");
        Map properties = this.getPluginContext();
        Set entries = properties.entrySet();
        this.getLog().info((CharSequence)("Entries.size " + entries.size()));
        for (Map.Entry entry : entries) {
            this.getLog().info((CharSequence)("... key=" + entry.getKey() + " = " + entry.getValue()));
        }
        try {
            StringBuffer buffer = new StringBuffer();
            Set<File> filesSet = this.resolveDependencies(this.libListWithDeps, this.libList);
            if (this.variableName != null) {
                String separatorUsed = "";
                for (File f : filesSet) {
                    buffer.append(separatorUsed);
                    buffer.append(f.getAbsolutePath());
                    separatorUsed = this.pathSeparator;
                }
                String classPathGenerated = buffer.toString();
                this.setVariable(classPathGenerated);
            }
            if (this.targetFolder != null) {
                this.targetFolder.mkdirs();
                for (File file : filesSet) {
                    Files.copy(file.toPath(), this.targetFolder.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
        catch (Throwable e) {
            this.getLog().error(e);
            if (this.optional) {
                this.setVariable("");
            }
            throw new MojoFailureException(e.getMessage());
        }
        finally {
            for (RemoteRepository repository : listRepo) {
                this.remoteRepos.remove(repository);
            }
        }
    }

    private void setVariable(String classPathGenerated) {
        if (this.variableName != null) {
            this.project.getProperties().setProperty(this.variableName, classPathGenerated);
            this.getLog().info((CharSequence)("dependency-scan setting: -D" + this.variableName + "=\"" + classPathGenerated + "\""));
        }
    }
}

