/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.boot.Artemis;
import org.apache.activemq.artemis.maven.ArtemisAbstractPlugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="upgrade", defaultPhase=LifecyclePhase.TEST_COMPILE)
public class ArtemisUpgradePlugin
extends ArtemisAbstractPlugin {
    @Parameter
    String name;
    private PluginDescriptor descriptor;
    @Parameter(defaultValue="${activemq.basedir}", required=true)
    private File home;
    @Parameter(defaultValue="${activemq.basedir}/artemis-distribution/target/apache-artemis-${project.version}-bin/apache-artemis-${project.version}/", required=true)
    private File alternateHome;
    @Parameter(defaultValue="${basedir}/target/server0", required=true)
    private File instance;
    @Parameter
    private String[] args;
    @Parameter
    boolean useSystemOutput = this.getLog().isDebugEnabled();

    @Override
    protected boolean isIgnore() {
        return false;
    }

    private void add(List<String> list, String ... str) {
        for (String s : str) {
            list.add(s);
        }
    }

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)("Local " + this.localRepository));
        MavenProject project = (MavenProject)this.getPluginContext().get("project");
        if (!this.isArtemisHome(this.home.toPath())) {
            if (this.isArtemisHome(this.alternateHome.toPath())) {
                this.home = this.alternateHome;
            } else {
                this.getLog().error((CharSequence)"********************************************************************************************");
                this.getLog().error((CharSequence)("Could not locate suitable Artemis.home on either " + this.home + " or " + this.alternateHome));
                this.getLog().error((CharSequence)"Use the binary distribution or build the distribution before running the examples");
                this.getLog().error((CharSequence)"********************************************************************************************");
                throw new MojoExecutionException("Couldn't find artemis.home");
            }
        }
        Map properties = this.getPluginContext();
        Set entries = properties.entrySet();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Entries.size " + entries.size()));
            for (Map.Entry entry : entries) {
                this.getLog().debug((CharSequence)("... key=" + entry.getKey() + " = " + entry.getValue()));
            }
        }
        ArrayList<String> listCommands = new ArrayList<String>();
        this.add(listCommands, "upgrade");
        this.add(listCommands, this.instance.getAbsolutePath());
        if (this.args != null) {
            for (String a : this.args) {
                this.add(listCommands, a);
            }
        }
        this.getLog().debug((CharSequence)("***** Server upgrading at " + this.instance + " with home=" + this.home + " *****"));
        try {
            Artemis.execute((File)this.home, null, null, (boolean)this.useSystemOutput, listCommands);
        }
        catch (Throwable throwable) {
            this.getLog().error(throwable);
            throw new MojoFailureException(throwable.getMessage());
        }
    }
}

